package cn.warpin.thirdPart.huawei.cfg;


import cn.warpin.thirdPart.huawei.obs.HuaweiObsCfg;
import cn.warpin.thirdPart.huawei.obs.obs.services.ObsConfiguration;
import cn.warpin.core.constant.Constants;

import static cn.warpin.core.constant.Constants.*;

public class HWCfgBuilder {


    public static HuaweiObsCfg OBSBuilder() {
        String active = Constants.ENV;
        HuaweiObsCfg cfg = new HuaweiObsCfg();
        cfg.setAccessKey(HWProp.accessKey);
        cfg.setSecretKey(HWProp.secretKey);
        cfg.setBucket(Constants.BUCKET);
        ObsConfiguration config = new ObsConfiguration();
        config.setSocketTimeout(30000);
        config.setConnectionTimeout(10000);
        config.setEndPoint(HWProp.endPoint);
        cfg.setConfig(config);

        if ("dev".equals(active)) {
            cfg.setPath(Constants.local_path);// 开发环境 使用本地环境的根目录
        } else if ("env".equals(active)) {
            cfg.setPath(Constants.dev_path);// 测试环境 使用测试环境的根目录
        } else {
            cfg.setPath(Constants.pro_path);// 正式环境 使用生产环境的根目录
        }
        return cfg;
    }


}
