package cn.warpin.thirdPart.aliyun.sms;

import cn.warpin.thirdPart.aliyun.cfg.AliCfgBuilder;
import cn.warpin.thirdPart.aliyun.cfg.AliProp;
import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.dysmsapi20170525.models.SendSmsResponse;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import cn.warpin.core.exception.ResultException;
import cn.warpin.core.result.ResCode;


public class SMSMgr {

    public static Client createClient(String accessKeyId, String accessKeySecret, String endpoint) throws Exception {
        Config config = new Config()
                // 您的 AccessKey ID
                .setAccessKeyId(accessKeyId)
                // 您的 AccessKey Secret
                .setAccessKeySecret(accessKeySecret);
        // 访问的域名
        config.endpoint = endpoint;
        return new Client(config);
    }

    // 发送短信验证码
    public static SendSmsResponse sendSMS(String tel, String code) {
        AliSmsCfg cfg = AliCfgBuilder.SMSBuilder();
        Client client = null;
        try {
            client = SMSMgr.createClient(AliProp.AccessKeyId, AliProp.AccessKeySecret, cfg.smsEndpoint);
            SendSmsRequest sendSmsRequest = new SendSmsRequest();
            sendSmsRequest.setPhoneNumbers(tel);
            sendSmsRequest.setSignName(cfg.signName);
            sendSmsRequest.setTemplateCode(cfg.templateCode);
            String templateParam = cfg.templateParam;
            String param = templateParam.replace("%s", code);
            sendSmsRequest.setTemplateParam(param);
            RuntimeOptions runtime = new RuntimeOptions();
            return client.sendSmsWithOptions(sendSmsRequest, runtime);
        } catch (Exception e) {
            throw new ResultException(ResCode.SMS_SEND_FAILED);
        }
    }

    /**
     * 发送短信，传入不同的模板code和参数
     * @param tel
     * @param templateCode
     * @param param
     * @return
     */
    public static SendSmsResponse sendSMS(String tel, String templateCode, String param) {
        AliSmsCfg cfg = AliCfgBuilder.SMSBuilder();
        Client client = null;
        try {
            client = SMSMgr.createClient(AliProp.AccessKeyId, AliProp.AccessKeySecret, cfg.smsEndpoint);
            SendSmsRequest sendSmsRequest = new SendSmsRequest();
            sendSmsRequest.setPhoneNumbers(tel);
            sendSmsRequest.setSignName(cfg.signName);
            sendSmsRequest.setTemplateCode(cfg.templateCode);
            sendSmsRequest.setTemplateParam(param);
            RuntimeOptions runtime = new RuntimeOptions();
            return client.sendSmsWithOptions(sendSmsRequest, runtime);
        } catch (Exception e) {
            throw new ResultException(ResCode.SMS_SEND_FAILED);
        }
    }


}
