package cn.warpin.thirdPart.aliyun.oss;


import cn.warpin.core.util.StrUtil;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.*;
import cn.warpin.thirdPart.aliyun.cfg.AliProp;
import org.apache.commons.io.IOUtils;
import org.springframework.web.multipart.MultipartFile;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.*;

import static cn.warpin.thirdPart.aliyun.cfg.AliProp.*;

public class AliOSS {

    private static Formatter styleFormatter;

    public static String IMG_TYPES = ".jpg,.gif,.bmp,.webp,.png";


    /**
     * 上传文件 可指定压缩或不压缩
     */
    public static void uploadFile(AliOssCfg cfg, MultipartFile file, String fileName, boolean isZoom) {
        OSS client = new OSSClientBuilder().build(cfg.getEndPoint(), AliProp.AccessKeyId, AliProp.AccessKeySecret);
        // 执行上传
        try {
            PutObjectResult rs = client.putObject(cfg.getBucket(), fileName, file.getInputStream());
            System.out.println(rs);
            // 如果尺寸过大则需要压缩
            if (isZoom) {
                zoomImg(cfg, client, fileName, getImgStyle(file.getSize(), file.getOriginalFilename()));
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }

        client.shutdown();
    }

    /**
     * 上传文件 可指定压缩或不压缩
     */
    public static void uploadFile(AliOssCfg cfg, String filePath, String fileName, boolean isZoom) {
        OSS client = new OSSClientBuilder().build(cfg.getEndPoint(), AliProp.AccessKeyId, AliProp.AccessKeySecret);
        File file = new File(filePath);
        // 执行上传
        client.putObject(cfg.getBucket(), fileName, new File(filePath));
        if (isZoom) {
            zoomImg(cfg, client, fileName, getImgStyle(file.length(), fileName));
        }
        client.shutdown();
    }

    public static void uploadBase64(AliOssCfg cfg, String base64, String fileName, boolean isZoom) {
        OSS client = new OSSClientBuilder().build(cfg.getEndPoint(), AliProp.AccessKeyId, AliProp.AccessKeySecret);
        byte[] bs = Base64.getDecoder().decode(base64);
        // 执行上传
        client.putObject(cfg.getBucket(), fileName, new ByteArrayInputStream(bs));
        if (isZoom) {
            zoomImg(cfg, client, fileName, getImgStyle((long) bs.length, fileName));
        }
        client.shutdown();
    }

    /**
     * 处理图片
     */
    private static void zoomImg(AliOssCfg cfg, OSS client, String imgName, String imgStyle) {
        if (StrUtil.isEmpty(imgStyle)) {
            return;
        }
        String bucketName = cfg.getBucket();
        StringBuilder sbStyle = new StringBuilder();
        styleFormatter = new Formatter(sbStyle);
        styleFormatter.format("%s|sys/saveas,o_%s,b_%s", imgStyle, BinaryUtil.toBase64String(imgName.getBytes()), BinaryUtil.toBase64String(bucketName.getBytes()));
        ProcessObjectRequest request = new ProcessObjectRequest(bucketName, imgName, sbStyle.toString());
        client.processObject(request);
    }

    public static void delFile(AliOssCfg cfg, String fileName) {
        OSS client = new OSSClientBuilder().build(cfg.getEndPoint(), AliProp.AccessKeyId, AliProp.AccessKeySecret);
        client.deleteObject(cfg.getBucket(), fileName);
        client.shutdown();
    }

    /**
     * 批量删除 返回失败列表 目前测试即使传入了 不存在的文件名 删除也不会报错
     */
    public static List<String> delFile(AliOssCfg cfg, List<String> files) {
        OSS client = new OSSClientBuilder().build(cfg.getEndPoint(), AliProp.AccessKeyId, AliProp.AccessKeySecret);
        List<String> keys = new ArrayList<>();
        for (String file : files) {
            keys.add(cfg.getPath() + file);
        }
        DeleteObjectsRequest req = new DeleteObjectsRequest(cfg.getBucket()).withKeys(keys);
        req.setQuiet(true);// 简单模式
        DeleteObjectsResult rs = client.deleteObjects(req);
        client.shutdown();
        List<String> fails = new ArrayList<>();
        for (String fail : rs.getDeletedObjects()) {
            fails.add(fail.replaceAll(cfg.getPath(), ""));
        }
        return fails;
    }

    public static InputStream getInputStream(AliOssCfg cfg, String fileName) {
        OSS client = new OSSClientBuilder().build(cfg.getEndPoint(), AliProp.AccessKeyId, AliProp.AccessKeySecret);
        OSSObject rs = client.getObject(cfg.getBucket(), fileName);
        InputStream in = rs.getObjectContent();
        return in;
    }

    public static String getBase64(AliOssCfg cfg, String fileName) throws IOException {
        OSS client = new OSSClientBuilder().build(cfg.getEndPoint(), AliProp.AccessKeyId, AliProp.AccessKeySecret);
        OSSObject rs = client.getObject(cfg.getBucket(), fileName);
        InputStream in = rs.getObjectContent();
        byte[] data = IOUtils.toByteArray(in);
        String base64 = Base64.getEncoder().encodeToString(data);
        client.shutdown();
        return base64;

    }

    /**
     * 获取文件格式
     */
    public static String getFmtName(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index < 0) {
            return ".jpg";
        } else {
            return fileName.substring(fileName.lastIndexOf(".")).toLowerCase();
        }
    }

    public static String rename(String fileName) {
        String fmtName = getFmtName(fileName);
        if (IMG_TYPES.indexOf(fmtName) < 0) {
            fmtName = ".jpg";
        }
        return UUID.randomUUID().toString() + fmtName;
    }

    /**
     * 根据图片大小和图片后缀决定获取图片格式化参数
     */
    public static String getImgStyle(Long fileSize, String fileName) {
        List<String> styles = new ArrayList<>();
        if (fileSize > maxSize) {
            styles.add(zoomStyle);
        }
        String fmtName = getFmtName(fileName);
        if (IMG_TYPES.indexOf(fmtName) < 0) {
            styles.add(fmtStyle);
        }
        if (styles.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer("image");
        for (String style : styles) {
            sb.append(style);
        }
        return sb.toString();
    }

}
