package cn.warpin.thirdPart.aliyun.cfg;


import cn.warpin.thirdPart.aliyun.sms.AliSmsCfg;
import cn.warpin.core.constant.Constants;
import cn.warpin.thirdPart.aliyun.oss.AliOssCfg;

import static cn.warpin.core.constant.Constants.dev_path;
import static cn.warpin.core.constant.Constants.pro_path;

public class AliCfgBuilder {


    public static AliOssCfg OSSBuilder() {
        String active = Constants.ENV;
        AliOssCfg cfg = new AliOssCfg();
        cfg.setBucket(Constants.BUCKET);
        cfg.setEndPoint(AliProp.endPoint_pub);//开发环境只能用共有节点名访问
        if (active == null || active.equals("dev") || active.equals("env")) {
            cfg.setPath(Constants.dev_path);// 开发环境 使用开发环境的根目录
        } else {
            cfg.setPath(Constants.pro_path);// 正式环境 使用生产环境的根目录
        }
        return cfg;
    }


    public static AliSmsCfg SMSBuilder() {
        AliSmsCfg cfg = new AliSmsCfg();
        cfg.setSignName(AliProp.signName);
        cfg.setTemplateCode(AliProp.templateCode1);
        cfg.setTemplateParam(AliProp.templateParam1);
        cfg.setSmsEndpoint(AliProp.smsEndpoint);
        return cfg;
    }


}
