/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.util;

public class SystemUtil {
    public static boolean isWindows() {
        String osName = SystemUtil.getOsName();
        return osName != null && osName.startsWith("Windows");
    }

    public static boolean isMacOs() {
        String osName = SystemUtil.getOsName();
        return osName != null && osName.startsWith("Mac");
    }

    public static boolean isLinux() {
        String osName = SystemUtil.getOsName();
        return osName != null && osName.startsWith("Linux") || !SystemUtil.isWindows() && !SystemUtil.isMacOs();
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static String getSymbol() {
        String osName = SystemUtil.getOsName();
        if (SystemUtil.isWindows()) {
            return "\\";
        }
        return "/";
    }

    public static void main(String[] args) {
        System.out.println(System.currentTimeMillis() / 1000L + 3600L);
    }
}

