/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.util;

import cn.warpin.core.util.RSA;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import org.apache.commons.lang3.StringUtils;

public class SignatureUtil {
    public static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    public static final String ENCODE_ALGORITHM = "SHA-256";
    private static final String dev_public_key = "30820122300d06092a864886f70d01010105000382010f003082010a02820101008fb286442ffb16d5ef91614ebffef2ac556d3904e592d8952aeef8c66ead53f20f4bed67645b43d07acdc6c1cb3f85b5987653a2425fd55b173c741d9caae72556d3192908a9b21b0ee7deb111cf3295ea3925f4fc4f3a3104e9b73bc4190ade0e1904c5c63cf658c4c1af85ae548e6ecaf2dea48d04094e20043cb8a542e399d6bf2af39591b0ce873369e01a79ce535b7fa44a1327143708d4032e4e376116880fc8eb438b82c7ce37db01597fbf8667bb0629b41aae3718dc1fe8ba739d2891b75ce3473d76fd0d5a21187f4b0b7d8f0933964511c815ab479f92dcd43202c504decf5ede323169999a78089001da0e1da22e325a7730e86da4d68b07d0790203010001";
    private static final String dev_private_key = "308204bc020100300d06092a864886f70d0101010500048204a6308204a20201000282010100ae84c96c63a2877c3bcd763e9c9a8501e43c040bea25b6b8e1211ebe9a3997a32ed6be42c2d15a23a831ed0dde655e475d44b84e4ac7061923b98ee10a715ecf2e41c8164a48608fbad27d9921466dcca6390e4fa4c45541a4d99794b1be9db450cda20642759bac55c70e7322cbc550970ecf35fb3175ffc3c2e64c6b142831f892d5d88038db276dd4d4c69212a1ab946338a4ce6ff3856ea68ab6cb40a2727448d20eb646f166cfd172567b2bf867536b1858caa692b0d094c257789fd0b1dba84c03d63863df39ce8449f275406252c8d4502834d631bd1ee3df755af455be6825a56ceede669d622dc8869d662d80ce02643d6b6d789adc26ad5b7dbce5020301000102820100716703e414d2562bda48669fc4ef7ba28106a6b27f52466bd88ec7059ffdf0952f2887b5a61697f637a349a10b74df508c40cd6ac2989553dcad053522ae0ca7a02d4ab1814f8abf9aec9084e2e47b10d2aa9cac102b2c235dd5aef4069410b24d17724393080d426cf2ce66eea36ef23156843b55a10c464894eb4599071e1e53a466ecedee2311d8b43614c5b745f8e07d8c857f04c9912e69a9d1426fde6de4366a0984f198c6efed59f7052950cdc0bb4f2e102ce565f1a9bee997bd3034a9c28bf2df2190da26e323168037b397750ba0cf11830648f2e0d2e039506e6c550014792890982764add0336b61be2662ac581900c76df2d695050b9ffeebc102818100fc2ea9d425f450762443cc5272aeb673f042c21c4403cf9b979374d085c49e7d791c4ea058241a165d5ed5d06392d1c7d2359ce9c034cd18109ead6514e43d7f4bfb9403f8a179aa0fac078e6a71faa3e87a157c5aec548825b4f0703423850ebd8971e6c5ee9c28082d112064edbc3bfff650fcccebb3d598a63119d97423e902818100b129230d5414e6d5b7b4d811771eb19d943e0241584932deb1f7a2e26f44c71f95fa0a5cd52a9c03d26c65751bfc09bcf06cc04dc0f4aa77e5b9fd1f2b9b1d2bd73a0921e227d01ba76760ac757f1ea6a47aa42b3488ac4b9428364c78cb2effcee9baea34577ab71e239d137f408a6207f62d9114b6fd40403055bae9869f9d028180097d3002bd92dddc342d20e9114ba5ade3227fef5457d85e006c19ff26a969554b53575a0d36fe8c4ce31ea482baa98e1d48cb28b884c41addb53acd0ce631b23287bae01360f0150815ef0adad2831ddbc78c3b6ba86cddda9d5e56ba7f83a8345591a59f590523347b8da36c68cda66c513666ecc709b345d52b0fcff0e0d102818003f9f766722fb1eab41fe405a855d108c76e08e0ec996001ed9eb05242cb19691515b2abd8c1071572e0a9fa51f17b4a795f0785f741c69dc05347622eb961933d567924008e82364cb09e53e0a344cddabd41f8124acb0b3b3d17d2e9972debe1fa0f0ef8b3c9f6583fd663bca47736b2150d7ac72b404df3e2e1d9bb2a21650281805113c565c968d8519e8997db27efe48660ba7749712ae3e700c4b60e847217fcb552b48fe74250bbdd2b8130c7b6ec9378590ad41f42a63cab4f7295173a0126c6a2448dda027e7c2f42ab84e3b94198a2d99adea1a9feea292bbb663ace21c1bacd833b29f402ed490370fe685a44c2821217afd6ea1e39f68ea643a389fbc8";
    private static final String pro_public_key = "30820122300d06092a864886f70d01010105000382010f003082010a0282010100ae84c96c63a2877c3bcd763e9c9a8501e43c040bea25b6b8e1211ebe9a3997a32ed6be42c2d15a23a831ed0dde655e475d44b84e4ac7061923b98ee10a715ecf2e41c8164a48608fbad27d9921466dcca6390e4fa4c45541a4d99794b1be9db450cda20642759bac55c70e7322cbc550970ecf35fb3175ffc3c2e64c6b142831f892d5d88038db276dd4d4c69212a1ab946338a4ce6ff3856ea68ab6cb40a2727448d20eb646f166cfd172567b2bf867536b1858caa692b0d094c257789fd0b1dba84c03d63863df39ce8449f275406252c8d4502834d631bd1ee3df755af455be6825a56ceede669d622dc8869d662d80ce02643d6b6d789adc26ad5b7dbce50203010001";
    private static final String pro_private_key = "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";

    public static String sign(String plainText, boolean isPro) throws Exception {
        String pk = null;
        if (StringUtils.isBlank((CharSequence)plainText)) {
            return null;
        }
        pk = isPro ? "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" : "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";
        PrivateKey privateKey = RSA.restorePrivateKey(SignatureUtil.hexStringToBytes(pk));
        MessageDigest messageDigest = MessageDigest.getInstance(ENCODE_ALGORITHM);
        messageDigest.update(plainText.getBytes());
        byte[] outputDigest_sign = messageDigest.digest();
        Signature Sign = Signature.getInstance(SIGNATURE_ALGORITHM);
        Sign.initSign(privateKey);
        Sign.update(outputDigest_sign);
        byte[] signed = Sign.sign();
        String sign = SignatureUtil.bytesToHexString(signed);
        return sign;
    }

    public static boolean verifySign(String pk, String plainText, String signed) throws Exception {
        if (StringUtils.isBlank((CharSequence)pk) || StringUtils.isBlank((CharSequence)plainText) || StringUtils.isBlank((CharSequence)signed)) {
            return false;
        }
        PublicKey publicKey = RSA.restorePublicKey(SignatureUtil.hexStringToBytes(pk));
        boolean signedSuccess = false;
        MessageDigest messageDigest = MessageDigest.getInstance(ENCODE_ALGORITHM);
        messageDigest.update(plainText.getBytes());
        byte[] outputDigest_verify = messageDigest.digest();
        Signature verifySign = Signature.getInstance(SIGNATURE_ALGORITHM);
        verifySign.initVerify(publicKey);
        verifySign.update(outputDigest_verify);
        signedSuccess = verifySign.verify(SignatureUtil.hexStringToBytes(signed));
        return signedSuccess;
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(SignatureUtil.charToByte(hexChars[pos]) << 4 | SignatureUtil.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }
}

