/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.util;

import cn.warpin.core.util.ObjectUtil;
import cn.warpin.core.util.StrUtil;
import com.alibaba.fastjson2.JSON;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class HttpUtil {
    private String authorizationHeader;

    public String postJson(RestTemplate restTemplate, String url, Object content) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (StrUtil.isNotEmpty(this.authorizationHeader)) {
            headers.set("Authorization", this.authorizationHeader);
        }
        String serviceData = JSON.toJSONString((Object)content);
        HttpEntity entity = new HttpEntity((Object)serviceData, (MultiValueMap)headers);
        String response = null;
        try {
            response = (String)restTemplate.postForObject(url, (Object)entity, String.class, new Object[0]);
        }
        catch (Exception e) {
            String errMsg = e.getMessage();
            throw new RuntimeException(errMsg);
        }
        System.out.println("==========\u8bf7\u6c42\u5730\u5740==========> : \n" + url);
        System.out.println("==========\u8bf7\u6c42\u7ed3\u679c==========> : \n" + response);
        return response;
    }

    public String postJson(RestTemplate restTemplate, String url, Object content, String username, String password) {
        String credentials = username + ":" + password;
        String encodedCredentials = Base64.getEncoder().encodeToString(credentials.getBytes());
        this.authorizationHeader = "Basic " + encodedCredentials;
        return this.postJson(restTemplate, url, content);
    }

    public String postForm(RestTemplate restTemplate, String url, Object content) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        if (StrUtil.isNotEmpty(this.authorizationHeader)) {
            headers.set("Authorization", this.authorizationHeader);
        }
        MultiValueMap<String, String> map = ObjectUtil.transBean2MultiValueMap(content);
        HttpEntity entity = new HttpEntity(map, (MultiValueMap)headers);
        String response = null;
        try {
            response = (String)restTemplate.postForObject(url, (Object)entity, String.class, new Object[0]);
        }
        catch (Exception e) {
            String errMsg = e.getMessage();
            throw new RuntimeException(errMsg);
        }
        System.out.println("==========\u8bf7\u6c42\u5730\u5740==========> : \n" + url);
        System.out.println("==========\u8bf7\u6c42\u7ed3\u679c==========> : \n" + response);
        return response;
    }

    public String postForm(RestTemplate restTemplate, String url, Object content, String username, String password) {
        String credentials = username + ":" + password;
        String encodedCredentials = Base64.getEncoder().encodeToString(credentials.getBytes());
        this.authorizationHeader = "Basic " + encodedCredentials;
        return this.postForm(restTemplate, url, content);
    }

    public String get(RestTemplate restTemplate, String url, Object content) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)url);
        if (content != null) {
            MultiValueMap<String, String> map = ObjectUtil.transBean2MultiValueMap(content);
            for (Map.Entry entry : map.entrySet()) {
                for (String value : (List)entry.getValue()) {
                    if (!StrUtil.isNotEmpty(value)) continue;
                    builder.queryParam((String)entry.getKey(), new Object[]{value});
                }
            }
        }
        String finalUrl = builder.toUriString();
        String response = null;
        try {
            response = (String)restTemplate.getForObject(finalUrl, String.class, new Object[0]);
        }
        catch (Exception e) {
            String errMsg = e.getMessage();
            throw new RuntimeException(errMsg);
        }
        System.out.println("==========\u8bf7\u6c42\u5730\u5740==========> : \n" + finalUrl);
        System.out.println("==========\u8bf7\u6c42\u7ed3\u679c==========> : \n" + response);
        return response;
    }
}

