/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.util;

import cn.warpin.core.constant.Constants;
import cn.warpin.core.exception.ResultException;
import cn.warpin.core.result.ResCode;
import cn.warpin.core.util.DateUtil;
import cn.warpin.core.util.StrUtil;
import cn.warpin.core.util.SystemUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.multipart.MultipartFile;

public class FileUtil {
    public static final String RESOURCE_PATH = Constants.RESOURCE_PATH;

    public static String createFile(String filePath, String fileName) {
        FileUtil.createFolder(filePath);
        String symbol = SystemUtil.getSymbol();
        String path = filePath + symbol + fileName;
        File file = new File(path);
        try {
            boolean r = file.createNewFile();
            if (!r) {
                System.out.println("\u521b\u5efa\u6587\u4ef6\u5931\u8d25\uff01");
            }
        }
        catch (IOException e) {
            throw new ResultException(ResCode.FILE_WRITE_FAIL);
        }
        return path;
    }

    public static Boolean checkFileExist(String filePath, String fileName) {
        String symbol = SystemUtil.getSymbol();
        String path = filePath + symbol + fileName;
        File file = new File(path);
        if (file.exists()) {
            return true;
        }
        return false;
    }

    public static String getFileType(String fileName) {
        int index = fileName.lastIndexOf(".");
        String typeName = "";
        typeName = index < 0 ? "png" : fileName.substring(index + 1);
        return typeName;
    }

    public static String rename(String fileName) {
        Path filePath = Paths.get(fileName, new String[0]);
        String extension = FileUtil.getFileExtension(filePath);
        String uuidStr = UUID.randomUUID().toString();
        String newName = FileUtil.removeFileExtension(filePath) + "_" + uuidStr + extension;
        return newName;
    }

    public static String getFileExtension(Path filePath) {
        String fileName = filePath.getFileName().toString();
        int dotIndex = fileName.lastIndexOf(".");
        if (dotIndex >= 0 && dotIndex < fileName.length() - 1) {
            return fileName.substring(dotIndex);
        }
        return "";
    }

    public static String removeFileExtension(Path filePath) {
        String fileName = filePath.getFileName().toString();
        int dotIndex = fileName.lastIndexOf(".");
        if (dotIndex >= 0) {
            return fileName.substring(0, dotIndex);
        }
        return fileName;
    }

    public static MediaType contentTypeSelector(String extension) {
        return switch (extension) {
            case ".txt" -> MediaType.valueOf((String)"text/plain");
            case ".jpg", ".jpeg" -> MediaType.valueOf((String)"image/jpeg");
            case ".png" -> MediaType.valueOf((String)"image/png");
            default -> MediaType.valueOf((String)"application/octet-stream");
        };
    }

    public static File multipartFileToFile(MultipartFile multipartFile, String fileName) throws Exception {
        String savePath = RESOURCE_PATH;
        File folder = new File(savePath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File file = new File(savePath + fileName);
        multipartFile.transferTo(file);
        return file;
    }

    public static void createFolder(String path) {
        File folder = new File(path);
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    public static void saveFile(MultipartFile file, String path) {
        File folder = new File(path);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        try {
            file.transferTo(new File(path));
        }
        catch (IOException e) {
            throw new ResultException(ResCode.FILE_WRITE_FAIL);
        }
    }

    public static String saveFile(MultipartFile file, String path, String fmtName) {
        String savePath = path + File.separator + fmtName;
        File folder = new File(path);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        try {
            file.transferTo(new File(savePath));
        }
        catch (IOException e) {
            throw new ResultException(ResCode.FILE_WRITE_FAIL);
        }
        return savePath;
    }

    public static void deleteFile(String fileName) {
        File file = new File(RESOURCE_PATH + Constants.PS + fileName);
        if (file.exists()) {
            file.delete();
        }
    }

    public static void deleteFile(String path, String fileName) {
        File file = new File(path + fileName);
        if (file.exists()) {
            file.delete();
        }
    }

    public static void saveFile(String base64, String fileName) throws Exception {
        File folder = new File(RESOURCE_PATH);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        byte[] b = Base64.getDecoder().decode(base64);
        for (int i = 0; i < b.length; ++i) {
            if (b[i] >= 0) continue;
            int n = i;
            b[n] = (byte)(b[n] + 256);
        }
        FileOutputStream out = new FileOutputStream(RESOURCE_PATH + fileName);
        ((OutputStream)out).write(b);
        out.flush();
        ((OutputStream)out).close();
    }

    public static void createFile(String path, byte[] content) throws IOException {
        FileOutputStream fos = new FileOutputStream(path);
        fos.write(content);
        fos.close();
    }

    public static MultipartFile getMultipartFile(String path) {
        File file = new File(path);
        String fileName = FileUtil.rename(file.getName());
        MockMultipartFile cMultiFile = null;
        try {
            cMultiFile = new MockMultipartFile("file", fileName, null, (InputStream)new FileInputStream(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return cMultiFile;
    }

    public static List<String> queryFileOfFolder(String path, String suffix) throws IOException {
        List filesInFolder = Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]).map(Path::toFile).collect(Collectors.toList());
        ArrayList<String> paths = new ArrayList<String>();
        for (File f : filesInFolder) {
            String fileName = f.getName();
            String filePath = f.getPath();
            if (StrUtil.isNotEmpty(suffix)) {
                String fileSuffix;
                if (!fileName.contains(".") || !(fileSuffix = fileName.substring(fileName.indexOf("."))).equals(suffix)) continue;
                paths.add(filePath);
                continue;
            }
            paths.add(filePath);
        }
        return paths;
    }

    public static String saveBufferedImageToFile(String base64string, String extensionName) throws Exception {
        BufferedImage src = FileUtil.base64ToBufferedImage(base64string);
        String path = "D:\\resource\\temp\\";
        String fileName = StrUtil.uuid32() + extensionName;
        String pathname = path + fileName;
        File outputfile = new File(pathname);
        ImageIO.write((RenderedImage)src, extensionName, outputfile);
        return fileName;
    }

    public static BufferedImage base64ToBufferedImage(String base64String) {
        try {
            byte[] bytes1 = Base64.getDecoder().decode(base64String);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes1);
            return ImageIO.read(bais);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static BufferedImage base64String2BufferedImage(String base64string) throws Exception {
        BufferedImage image = null;
        InputStream stream = FileUtil.BaseToInputStream(base64string);
        image = ImageIO.read(stream);
        return image;
    }

    private static InputStream BaseToInputStream(String base64string) throws Exception {
        ByteArrayInputStream stream = null;
        byte[] bytes1 = Base64.getDecoder().decode(base64string);
        stream = new ByteArrayInputStream(bytes1);
        return stream;
    }

    private static String imageToBase64(BufferedImage bufferedImage) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "jpg", baos);
        return new String(Base64.getEncoder().encode(baos.toByteArray()));
    }

    public static void generateImage(String base64, String targetPath, String extensionName) {
        try {
            Base64.Decoder decoder = Base64.getMimeDecoder();
            byte[] b = decoder.decode(base64);
            for (int i = 0; i < b.length; ++i) {
                if (b[i] >= 0) continue;
                int n = i;
                b[n] = (byte)(b[n] + 256);
            }
            String date = DateUtil.longToString(System.currentTimeMillis(), "yyyyMMddHHmmss");
            String filePath = targetPath + "\\al_upload_" + date + "." + extensionName;
            FileOutputStream out = new FileOutputStream(filePath);
            ((OutputStream)out).write(b);
            out.flush();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getHtmlFromUrl(String url) {
        String str = null;
        StringBuffer sb = new StringBuffer();
        try {
            URL uri = new URL(url);
            InputStream in = uri.openStream();
            InputStreamReader isr = new InputStreamReader(in);
            BufferedReader bufr = new BufferedReader(isr);
            while ((str = bufr.readLine()) != null) {
                sb.append(str);
            }
            bufr.close();
            isr.close();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static int getIntFromColor(int Red, int Green, int Blue) {
        Red = Red << 16 & 0xFF0000;
        Green = Green << 8 & 0xFF00;
        return 0xFF000000 | Red | Green | (Blue &= 0xFF);
    }

    public static int getIntFromColor(int Red, int Green, int Blue, int Alpha) {
        Red = Red << 16 & 0xFF0000;
        Green = Green << 8 & 0xFF00;
        return 0xFF000000 | Red | Green | (Blue &= 0xFF) | (Alpha <<= 24);
    }

    public static String getOssKey(String filename, String ossContext, String project, String type, String context, String content, String platform, boolean isWindows) {
        String slash = "/";
        if (platform.equals("0") && isWindows) {
            slash = "\\\\";
        }
        String objectKey = project + slash + ossContext;
        objectKey = StrUtil.isEmpty(type) ? objectKey + slash + "common" : objectKey + slash + type;
        if (StrUtil.isNotEmpty(context)) {
            objectKey = objectKey + slash + context;
        }
        if (StrUtil.isNotEmpty(content)) {
            objectKey = objectKey + slash + content;
        }
        objectKey = objectKey + slash + filename;
        System.out.println("----- relativePath: " + objectKey);
        return objectKey;
    }
}

