/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.security.jwt;

import cn.warpin.core.constant.EnumStore;
import cn.warpin.core.database.redis.RedisOperate;
import cn.warpin.core.util.DateUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class JwtUtils {
    public static final String TOKEN_HEADER = "Authorization";
    public static final String TOKEN_PREFIX = "Bearer ";
    public static final String SUBJECT = "congge";
    public static final long EXPIRATION = 604800000L;
    public static final String APPSECRET_KEY = "congge_secret";
    private static final String ROLE_CLAIMS = "rol";
    private static final String VERSION = "version";

    public static String createToken(String loginType, String account, String id) {
        Map<String, String> params = JwtUtils.getJwtClaimParams(loginType, id);
        String redisKey = params.get("redisKey");
        String token = Jwts.builder().setId(id).setSubject(params.get("subject")).setAudience(params.get("audience")).setIssuer(account).claim("account", (Object)account).claim("loginType", (Object)loginType).claim(VERSION, (Object)params.get(VERSION)).setIssuedAt(new Date()).setExpiration(new Date(System.currentTimeMillis() + 604800000L)).signWith(SignatureAlgorithm.HS256, APPSECRET_KEY).compact();
        HashMap<String, String> mapValue = new HashMap<String, String>();
        mapValue.put(EnumStore.CACHE_TOKEN_KEY.getValue(), token);
        mapValue.put(EnumStore.CACHE_TOKEN_VERSION_KEY.getValue(), params.get(VERSION));
        RedisOperate.setMapValue(redisKey, mapValue, 0L);
        return token;
    }

    public static Claims checkJWT(String token) {
        try {
            Claims claims = (Claims)Jwts.parser().setSigningKey(APPSECRET_KEY).parseClaimsJws(token).getBody();
            return claims;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getUsername(String token) {
        Claims claims = (Claims)Jwts.parser().setSigningKey(APPSECRET_KEY).parseClaimsJws(token).getBody();
        return claims.get((Object)"account").toString();
    }

    public static String getUserRole(String token) {
        Claims claims = (Claims)Jwts.parser().setSigningKey(APPSECRET_KEY).parseClaimsJws(token).getBody();
        return claims.get((Object)ROLE_CLAIMS).toString();
    }

    public static boolean isExpiration(String token) {
        Claims claims = (Claims)Jwts.parser().setSigningKey(APPSECRET_KEY).parseClaimsJws(token).getBody();
        return claims.getExpiration().before(new Date());
    }

    public static Map<String, String> getJwtClaimParams(String loginType, String id) {
        HashMap<String, String> resInfo = new HashMap<String, String>();
        String role = "";
        Object redisKey = "";
        Object version = "";
        if (loginType.equals(EnumStore.LOGIN_TYPE_ADMIN.getKey())) {
            role = "superAdmin";
            redisKey = EnumStore.CACHE_ADMIN_TOKEN_KEY.getValue() + id;
            version = role + "_" + id + DateUtil.longToString(System.currentTimeMillis(), "yyyyMMddHHmmss.SSS");
            resInfo.put("subject", EnumStore.LOGIN_TYPE_ADMIN.getValue());
            resInfo.put("audience", role);
            resInfo.put("redisKey", (String)redisKey);
            resInfo.put(VERSION, (String)version);
        }
        if (loginType.equals(EnumStore.LOGIN_TYPE_EMP.getKey())) {
            role = "employee";
            redisKey = EnumStore.CACHE_EMP_TOKEN_KEY.getValue() + id;
            version = role + "_" + id + DateUtil.longToString(System.currentTimeMillis(), "yyyyMMddHHmmss.SSS");
            resInfo.put("subject", EnumStore.LOGIN_TYPE_EMP.getValue());
            resInfo.put("audience", role);
            resInfo.put("redisKey", (String)redisKey);
            resInfo.put(VERSION, (String)version);
        }
        if (loginType.equals(EnumStore.LOGIN_TYPE_USER.getKey())) {
            role = "user";
            redisKey = EnumStore.CACHE_USER_TOKEN_KEY.getValue() + id;
            version = role + "_" + id + DateUtil.longToString(System.currentTimeMillis(), "yyyyMMddHHmmss.SSS");
            resInfo.put("subject", EnumStore.LOGIN_TYPE_USER.getValue());
            resInfo.put("audience", role);
            resInfo.put("redisKey", (String)redisKey);
            resInfo.put(VERSION, (String)version);
        }
        return resInfo;
    }
}

