/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.security.config;

import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="security")
public class SecurityConfigProperties {
    private Jwt jwt;
    private List<String> whiteList = new ArrayList<String>();

    public Jwt getJwt() {
        return this.jwt;
    }

    public List<String> getWhiteList() {
        return this.whiteList;
    }

    public void setJwt(Jwt jwt) {
        this.jwt = jwt;
    }

    public void setWhiteList(List<String> whiteList) {
        this.whiteList = whiteList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecurityConfigProperties)) {
            return false;
        }
        SecurityConfigProperties other = (SecurityConfigProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Jwt this$jwt = this.getJwt();
        Jwt other$jwt = other.getJwt();
        if (this$jwt == null ? other$jwt != null : !((Object)this$jwt).equals(other$jwt)) {
            return false;
        }
        List<String> this$whiteList = this.getWhiteList();
        List<String> other$whiteList = other.getWhiteList();
        return !(this$whiteList == null ? other$whiteList != null : !((Object)this$whiteList).equals(other$whiteList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SecurityConfigProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Jwt $jwt = this.getJwt();
        result = result * 59 + ($jwt == null ? 43 : ((Object)$jwt).hashCode());
        List<String> $whiteList = this.getWhiteList();
        result = result * 59 + ($whiteList == null ? 43 : ((Object)$whiteList).hashCode());
        return result;
    }

    public String toString() {
        return "SecurityConfigProperties(jwt=" + String.valueOf(this.getJwt()) + ", whiteList=" + String.valueOf(this.getWhiteList()) + ")";
    }

    public static class Jwt {
        private String secretKey;
        private long expiration;
        private RefreshToken refreshToken;

        public String getSecretKey() {
            return this.secretKey;
        }

        public long getExpiration() {
            return this.expiration;
        }

        public RefreshToken getRefreshToken() {
            return this.refreshToken;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public void setExpiration(long expiration) {
            this.expiration = expiration;
        }

        public void setRefreshToken(RefreshToken refreshToken) {
            this.refreshToken = refreshToken;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Jwt)) {
                return false;
            }
            Jwt other = (Jwt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getExpiration() != other.getExpiration()) {
                return false;
            }
            String this$secretKey = this.getSecretKey();
            String other$secretKey = other.getSecretKey();
            if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
                return false;
            }
            RefreshToken this$refreshToken = this.getRefreshToken();
            RefreshToken other$refreshToken = other.getRefreshToken();
            return !(this$refreshToken == null ? other$refreshToken != null : !((Object)this$refreshToken).equals(other$refreshToken));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Jwt;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $expiration = this.getExpiration();
            result = result * 59 + (int)($expiration >>> 32 ^ $expiration);
            String $secretKey = this.getSecretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            RefreshToken $refreshToken = this.getRefreshToken();
            result = result * 59 + ($refreshToken == null ? 43 : ((Object)$refreshToken).hashCode());
            return result;
        }

        public String toString() {
            return "SecurityConfigProperties.Jwt(secretKey=" + this.getSecretKey() + ", expiration=" + this.getExpiration() + ", refreshToken=" + String.valueOf(this.getRefreshToken()) + ")";
        }

        public static class RefreshToken {
            private long expiration;

            public long getExpiration() {
                return this.expiration;
            }

            public void setExpiration(long expiration) {
                this.expiration = expiration;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RefreshToken)) {
                    return false;
                }
                RefreshToken other = (RefreshToken)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return this.getExpiration() == other.getExpiration();
            }

            protected boolean canEqual(Object other) {
                return other instanceof RefreshToken;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $expiration = this.getExpiration();
                result = result * 59 + (int)($expiration >>> 32 ^ $expiration);
                return result;
            }

            public String toString() {
                return "SecurityConfigProperties.Jwt.RefreshToken(expiration=" + this.getExpiration() + ")";
            }
        }
    }
}

