/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.exception;

import cn.warpin.core.exception.ResultException;
import cn.warpin.core.result.ResCode;
import cn.warpin.core.result.Result;
import com.alibaba.fastjson.JSONObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.HandlerMethod;

@RestControllerAdvice
@CrossOrigin
public class GlobalException {
    private static final Logger log = LoggerFactory.getLogger(GlobalException.class);
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final String LOGUUID = "logUUID";
    private static long pushTime = 0L;

    @ExceptionHandler(value={ResultException.class})
    @ResponseBody
    public Result exception(HttpServletRequest request, HttpServletResponse response, HandlerMethod o, Exception ex, ResultException resultException) {
        ex.printStackTrace();
        log.error("\u3010\u5168\u5c40\u5f02\u5e38\u3011\u5f02\u5e38\u8be6\u7ec6\u65b9\u6cd5\u540d\u79f0:{}", (Object)request.getServletPath());
        log.error("\u3010\u5168\u5c40\u5f02\u5e38\u3011\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f:{}", (Throwable)ex);
        log.error("\u3010\u5168\u5c40\u5f02\u5e38\u3011\u5f02\u5e38\u4fe1\u606ferrorMsg:{}", (Object)ex.getMessage());
        if (GlobalException.pushFrequency(30)) {
            log.info("\u53d1\u9001\u5f02\u5e38\u90ae\u4ef6");
        } else {
            log.error("\u9519\u8bef\u65e5\u5fd7\uff01error:{}", (Object)GlobalException.emailContent(request, o, ex, null));
        }
        if (resultException != null) {
            Result.fail(ResCode.SERVER_COMMON_ERROR, "\u672a\u77e5\u9519\u8bef");
        }
        return Result.fail(resultException.getCode(), resultException.getMsg());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String errInfo(Exception e) {
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.flush();
            sw.flush();
        }
        finally {
            if (sw != null) {
                try {
                    sw.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (pw != null) {
                pw.close();
            }
        }
        return sw.toString();
    }

    public static String emailContent(HttpServletRequest request, HandlerMethod o, Exception ex, String[] customExMsg) {
        Class<?>[] methodClass;
        String time = sdf.format(new Date());
        String url = request.getRequestURI();
        String requestWay = request.getMethod();
        String requestMethodName = o.getMethod().getName();
        StringBuffer sb = new StringBuffer();
        for (Class<?> c : methodClass = o.getMethod().getParameterTypes()) {
            sb.append(c.getName() + ",");
        }
        String params = GlobalException.getRequestParams(request);
        String html = "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n<title>learn Resources</title>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n</head>\n<body>\n\n%s\n</body>\n</html>";
        StringBuffer sx = new StringBuffer();
        sx.append("<h3>\u8bf7\u6c42\u5730\u5740:</h3>" + url);
        sx.append("<h3>\u8bf7\u6c42\u65b9\u5f0f:</h3>" + requestWay);
        sx.append("<h3>\u65e5\u5fd7\u8ddf\u8e2aID:</h3>" + MDC.get((String)LOGUUID));
        sx.append("<h3>\u8bf7\u6c42\u65b9\u6cd5:</h3>" + requestMethodName + "(" + sb.toString().substring(0, sb.toString().lastIndexOf(",")) + ")");
        sx.append("<h3>\u8bf7\u6c42\u53c2\u6570:</h3>" + (StringUtils.isEmpty((Object)params) ? "" : params));
        sx.append("<h3>\u5f02\u5e38\u65f6\u95f4:</h3>" + time);
        if (!StringUtils.isEmpty((Object)customExMsg)) {
            sx.append("<h3>\u81ea\u5b9a\u4e49\u5f02\u5e38\u65e5\u5fd7:</h3>code:" + customExMsg[0] + ";msg:" + customExMsg[1]);
        } else {
            sx.append("<h3>\u5f02\u5e38\u65e5\u5fd7:</h3>" + (StringUtils.isEmpty((Object)ex.getMessage()) ? "" : ex.getMessage()));
        }
        sx.append("<h3>\u5f02\u5e38\u8be6\u7ec6:</h3>" + GlobalException.errInfo(ex));
        return String.format(html, sx);
    }

    public static String getUrl(HttpServletRequest request) {
        String s = request.getRequestURI();
        String x = s.substring(s.indexOf("/") + 2);
        String url = x.substring(x.indexOf("/"));
        return url;
    }

    public static String getRequestParams(HttpServletRequest request) {
        Map map = request.getParameterMap();
        if (map.size() == 0 && request.getContentType().equals("text/xml")) {
            map = (Map)request.getAttribute("paramValue");
        }
        return JSONObject.toJSONString((Object)map);
    }

    public static boolean pushFrequency(Integer seconds) {
        if (pushTime != 0L && (System.currentTimeMillis() - pushTime) / 1000L >= (long)seconds.intValue()) {
            pushTime = System.currentTimeMillis();
        } else if (pushTime == 0L) {
            pushTime = System.currentTimeMillis();
        } else {
            return false;
        }
        return true;
    }
}

