/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.database.redis;

import cn.warpin.core.database.redis.RedisClientSingleton;
import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import java.util.List;
import java.util.Map;

public class RedisOperate {
    public static void setValue(String key, String value, long expiration) {
        RedisClient redisClient = RedisClientSingleton.getRedisClient();
        StatefulRedisConnection connection = redisClient.connect();
        RedisCommands redisCommands = connection.sync();
        redisCommands.set((Object)key, (Object)value);
        if (expiration > 0L) {
            redisCommands.expire((Object)key, expiration);
        }
        connection.close();
    }

    public static String getValue(String key) {
        RedisClient redisClient = RedisClientSingleton.getRedisClient();
        StatefulRedisConnection connection = redisClient.connect();
        RedisCommands redisCommands = connection.sync();
        String value = (String)redisCommands.get((Object)key);
        connection.close();
        return value;
    }

    public static void deleteValue(String key) {
        RedisClient redisClient = RedisClientSingleton.getRedisClient();
        StatefulRedisConnection connection = redisClient.connect();
        RedisCommands redisCommands = connection.sync();
        redisCommands.del((Object[])new String[]{key});
        connection.close();
    }

    public static void setMapValue(String key, Map<String, String> mapValue, long expiration) {
        RedisClient redisClient = RedisClientSingleton.getRedisClient();
        StatefulRedisConnection connection = redisClient.connect();
        RedisCommands redisCommands = connection.sync();
        redisCommands.hmset((Object)key, mapValue);
        if (expiration > 0L) {
            redisCommands.expire((Object)key, expiration);
        }
        connection.close();
    }

    public static Map<String, String> getMapValue(String key) {
        RedisClient redisClient = RedisClientSingleton.getRedisClient();
        StatefulRedisConnection connection = redisClient.connect();
        RedisCommands redisCommands = connection.sync();
        Map resultMap = redisCommands.hgetall((Object)key);
        connection.close();
        return resultMap;
    }

    public static void setListValue(String key, List<String> values, long expiration) {
        RedisClient redisClient = RedisClientSingleton.getRedisClient();
        StatefulRedisConnection connection = redisClient.connect();
        RedisCommands redisCommands = connection.sync();
        Object[] vs = values.toArray(new String[values.size()]);
        redisCommands.lpush((Object)key, vs);
        if (expiration > 0L) {
            redisCommands.expire((Object)key, expiration);
        }
        connection.close();
    }

    public static List<String> getListValue(String key, int start, int stop) {
        RedisClient redisClient = RedisClientSingleton.getRedisClient();
        StatefulRedisConnection connection = redisClient.connect();
        RedisCommands redisCommands = connection.sync();
        List resultList = redisCommands.lrange((Object)key, (long)start, (long)stop);
        connection.close();
        return resultList;
    }

    public static void deleteListValue(String key, String value) {
        RedisClient redisClient = RedisClientSingleton.getRedisClient();
        StatefulRedisConnection connection = redisClient.connect();
        RedisCommands redisCommands = connection.sync();
        redisCommands.lrem((Object)key, 0L, (Object)value);
        connection.close();
    }

    public static void deleteListValue(String key, List<String> values) {
        RedisClient redisClient = RedisClientSingleton.getRedisClient();
        StatefulRedisConnection connection = redisClient.connect();
        RedisCommands redisCommands = connection.sync();
        for (String value : values) {
            redisCommands.lrem((Object)key, 0L, (Object)value);
        }
        connection.close();
    }
}

