/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.database.elastic;

import cn.warpin.core.constant.Constants;
import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;

public class ElasticSingleton {
    private static volatile ElasticSingleton instance;
    private ElasticsearchClient client;

    private ElasticSingleton() {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(Constants.ELASTIC_USERNAME, Constants.ELASTIC_PWD));
        RestClient restClient = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(Constants.ELASTIC_IP, Constants.ELASTIC_PORT.intValue())}).setHttpClientConfigCallback(arg_0 -> ElasticSingleton.lambda$new$0((CredentialsProvider)credentialsProvider, arg_0)).build();
        RestClientTransport transport = new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper());
        this.client = new ElasticsearchClient((ElasticsearchTransport)transport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ElasticSingleton getInstance() {
        if (instance != null) return instance;
        Class<ElasticSingleton> clazz = ElasticSingleton.class;
        synchronized (ElasticSingleton.class) {
            if (instance != null) return instance;
            instance = new ElasticSingleton();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void close() throws IOException {
        ((ElasticsearchTransport)this.client._transport()).close();
    }

    public ElasticsearchClient getClient() {
        return this.client;
    }

    public void setClient(ElasticsearchClient client) {
        this.client = client;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticSingleton)) {
            return false;
        }
        ElasticSingleton other = (ElasticSingleton)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ElasticsearchClient this$client = this.getClient();
        ElasticsearchClient other$client = other.getClient();
        return !(this$client == null ? other$client != null : !this$client.equals(other$client));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElasticSingleton;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ElasticsearchClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        return result;
    }

    public String toString() {
        return "ElasticSingleton(client=" + String.valueOf(this.getClient()) + ")";
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$new$0(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

