/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.base.jpa.tools;

import jakarta.persistence.Column;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;

public class ColumnTool {
    public static String getStringType(String databaseType, int length) {
        return switch (databaseType.toLowerCase()) {
            case "mysql", "postgresql" -> String.format("VARCHAR(%d)", length);
            case "oracle" -> String.format("VARCHAR2(%d)", length);
            case "sqlserver" -> String.format("NVARCHAR(%d)", length);
            default -> throw new UnsupportedOperationException("Unsupported database type: " + databaseType);
        };
    }

    public static String getIntType(String databaseType) {
        return switch (databaseType.toLowerCase()) {
            case "mysql", "postgresql", "sqlserver" -> "INT";
            case "oracle" -> "NUMBER";
            default -> throw new UnsupportedOperationException("Unsupported database type: " + databaseType);
        };
    }

    public static String getBigIntType(String databaseType) {
        return switch (databaseType.toLowerCase()) {
            case "mysql", "postgresql", "sqlserver" -> "BIGINT";
            case "oracle" -> "NUMBER";
            default -> throw new UnsupportedOperationException("Unsupported database type: " + databaseType);
        };
    }

    public static String getDoubleType(String databaseType, int precision, int scale) {
        return switch (databaseType.toLowerCase()) {
            case "mysql" -> {
                if (precision > 0) {
                    yield String.format("DOUBLE(%d, %d)", precision, scale);
                }
                yield "DOUBLE";
            }
            case "postgresql" -> {
                if (precision > 0) {
                    yield String.format("DOUBLE PRECISION(%d, %d)", precision, scale);
                }
                yield "DOUBLE PRECISION";
            }
            case "oracle" -> {
                if (precision > 0) {
                    yield String.format("NUMBER(%d, %d)", precision, scale);
                }
                yield "NUMBER";
            }
            case "sqlserver" -> {
                if (precision > 0) {
                    yield String.format("FLOAT(%d)", precision);
                }
                yield "FLOAT";
            }
            default -> throw new UnsupportedOperationException("Unsupported database type: " + databaseType);
        };
    }

    public static String getFloatType(String databaseType, int precision, int scale) {
        return switch (databaseType.toLowerCase()) {
            case "mysql" -> {
                if (precision > 0) {
                    yield String.format("FLOAT(%d, %d)", precision, scale);
                }
                yield "FLOAT";
            }
            case "postgresql" -> {
                if (precision > 0) {
                    yield String.format("REAL(%d, %d)", precision, scale);
                }
                yield "REAL";
            }
            case "oracle" -> {
                if (precision > 0) {
                    yield String.format("BINARY_FLOAT(%d, %d)", precision, scale);
                }
                yield "BINARY_FLOAT";
            }
            case "sqlserver" -> {
                if (precision > 0) {
                    yield String.format("REAL(%d)", precision);
                }
                yield "REAL";
            }
            default -> throw new UnsupportedOperationException("Unsupported database type: " + databaseType);
        };
    }

    public static String getDateType(String databaseType) {
        switch (databaseType.toLowerCase()) {
            case "mysql": 
            case "postgresql": 
            case "oracle": 
            case "sqlserver": {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported database type: " + databaseType);
            }
        }
        return "DATE";
    }

    public static String getDateTimeType(String databaseType) {
        return switch (databaseType.toLowerCase()) {
            case "mysql", "postgresql", "oracle" -> "TIMESTAMP";
            case "sqlserver" -> "DATETIME";
            default -> throw new UnsupportedOperationException("Unsupported database type: " + databaseType);
        };
    }

    public static String getDecimalType(String databaseType, int precision, int scale) {
        String s = precision > 0 ? String.format("DECIMAL(%d, %d)", precision, scale) : "DECIMAL";
        return switch (databaseType.toLowerCase()) {
            case "mysql", "postgresql", "sqlserver" -> s;
            case "oracle" -> {
                if (precision > 0) {
                    yield String.format("NUMBER(%d, %d)", precision, scale);
                }
                yield "NUMBER";
            }
            default -> throw new UnsupportedOperationException("Unsupported database type: " + databaseType);
        };
    }

    public static String getColumnType(Field field, String databaseType) {
        Column column = field.getAnnotation(Column.class);
        if (column == null) {
            return null;
        }
        if (!column.columnDefinition().isEmpty()) {
            return column.columnDefinition();
        }
        Class<?> fieldType = field.getType();
        if (String.class.equals(fieldType)) {
            int length = column.length();
            return length > 0 ? ColumnTool.getStringType(databaseType, length) : ColumnTool.getStringType(databaseType, 255);
        }
        if (Integer.TYPE.equals(fieldType) || Integer.class.equals(fieldType)) {
            return ColumnTool.getIntType(databaseType);
        }
        if (Long.TYPE.equals(fieldType) || Long.class.equals(fieldType)) {
            return ColumnTool.getBigIntType(databaseType);
        }
        if (Double.TYPE.equals(fieldType) || Double.class.equals(fieldType)) {
            int precision = column.precision();
            int scale = column.scale();
            return ColumnTool.getDoubleType(databaseType, precision, scale);
        }
        if (Float.TYPE.equals(fieldType) || Float.class.equals(fieldType)) {
            int precision = column.precision();
            int scale = column.scale();
            return ColumnTool.getFloatType(databaseType, precision, scale);
        }
        if (Date.class.equals(fieldType)) {
            return ColumnTool.getDateType(databaseType);
        }
        if (Timestamp.class.equals(fieldType)) {
            return ColumnTool.getDateTimeType(databaseType);
        }
        if (BigDecimal.class.equals(fieldType)) {
            int precision = column.precision();
            int scale = column.scale();
            return ColumnTool.getDecimalType(databaseType, precision, scale);
        }
        return null;
    }
}

