/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.base.jpa.jpaStrategy;

import com.google.common.base.CaseFormat;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.PhysicalNamingStrategyStandardImpl;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CustomPhysicalNamingStrategy
extends PhysicalNamingStrategyStandardImpl {
    public Identifier toPhysicalColumnName(Identifier name, JdbcEnvironment context) {
        String columnName = name.getText();
        String snakeCaseColumnName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, columnName);
        snakeCaseColumnName = snakeCaseColumnName.toLowerCase();
        return Identifier.toIdentifier((String)snakeCaseColumnName);
    }

    public Identifier toPhysicalTableName(Identifier name, JdbcEnvironment context) {
        String tableName = name.getText();
        String snakeCaseTableName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, tableName);
        snakeCaseTableName = snakeCaseTableName.toLowerCase();
        return Identifier.toIdentifier((String)snakeCaseTableName);
    }
}

