/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.base.jpa.jpaComment.repository;

import cn.warpin.core.base.jpa.jpaComment.enums.DbTypeEnum;
import jakarta.annotation.Resource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class JpaCommentRepository {
    @Resource
    public JdbcTemplate jdbcTemplate;

    public void alterTableComment(String tableName, String tableComment) {
        String sql = this.getTableAlterSql(tableName);
        this.jdbcTemplate.update(sql, new Object[]{tableComment});
    }

    public void alterColumnComment(String tableName, String columnName, String columnComment) {
        String sql = this.getColumnCommentAlterSql(tableName, columnName);
        this.jdbcTemplate.update(sql, new Object[]{columnComment});
    }

    private String getTableAlterSql(String tableName) {
        String databaseType = this.getDatabaseType();
        Object sql = "";
        if (databaseType.contains(DbTypeEnum.MYSQL.getValue())) {
            sql = "ALTER TABLE " + tableName + " COMMENT = ?";
        } else if (databaseType.contains(DbTypeEnum.SQLSERVER.getValue())) {
            sql = "EXEC sp_updateextendedproperty 'MS_Description', ?, 'SCHEMA', 'dbo', 'TABLE', " + tableName;
        } else if (databaseType.contains(DbTypeEnum.ORACLE.getValue()) || databaseType.contains(DbTypeEnum.POSTGRESQL.getValue())) {
            sql = "COMMENT ON TABLE " + tableName + " IS ?";
        } else {
            throw new IllegalArgumentException("Unsupported database type: " + databaseType);
        }
        return sql;
    }

    private String getColumnCommentAlterSql(String tableName, String columnName) {
        String databaseType = this.getDatabaseType();
        Object sql = "";
        if (databaseType.contains(DbTypeEnum.MYSQL.getValue())) {
            sql = "ALTER TABLE " + tableName + " MODIFY " + columnName + " ADD COMMENT ?";
        } else if (databaseType.contains(DbTypeEnum.SQLSERVER.getValue())) {
            sql = "EXEC sp_updateextendedproperty 'MS_Description', ?, 'SCHEMA', 'dbo', 'TABLE', " + tableName + ", 'COLUMN', " + columnName;
        } else if (databaseType.contains(DbTypeEnum.ORACLE.getValue()) || databaseType.contains(DbTypeEnum.POSTGRESQL.getValue())) {
            sql = "COMMENT ON COLUMN " + tableName + "." + columnName + " IS ?";
        } else {
            throw new IllegalArgumentException("Unsupported database type: " + databaseType);
        }
        return sql;
    }

    public String getDatabaseType() {
        block8: {
            String string;
            block9: {
                DataSource dataSource = this.jdbcTemplate.getDataSource();
                if (dataSource == null) break block8;
                Connection connection = dataSource.getConnection();
                try {
                    DatabaseMetaData metaData = connection.getMetaData();
                    string = metaData.getDatabaseProductName().toUpperCase();
                    if (connection == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
                connection.close();
            }
            return string;
        }
        return "Unknown";
    }
}

