/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.base.dao;

import cn.warpin.core.base.condition.BaseCondition;
import cn.warpin.core.base.condition.QueryCondition;
import cn.warpin.core.base.tableConf.bean.TableConf;
import cn.warpin.core.exception.ResultException;
import cn.warpin.core.result.ResCode;
import cn.warpin.core.util.ArrayUtil;
import cn.warpin.core.util.ObjectUtil;
import cn.warpin.core.util.StrUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DaoUtil {
    public static String distanceScopeSql(Double longitudeGPS, Double latitudeGPS) {
        return " ROUND(6378.138 * 2 * ASIN(SQRT(POW(SIN((" + latitudeGPS + " * PI() / 180 - latitude * PI() / 180) / 2), 2) + COS(" + latitudeGPS + "  * PI() / 180) * COS(latitude * PI() / 180) * POW(SIN((" + longitudeGPS + " * PI() / 180 - longitude * PI() / 180) / 2),2))) * 1000) ";
    }

    public static String setExternalCondition(QueryCondition queryCondition, List<TableConf> confs, Map<String, Object> params) {
        StringBuffer conditionSql = new StringBuffer("");
        if (ArrayUtil.isEmpty(confs)) {
            return conditionSql.toString();
        }
        if (queryCondition != null) {
            BaseCondition baseCondition = queryCondition.getBaseCondition();
            Object entity = queryCondition.getEntity();
            try {
                if (baseCondition != null) {
                    String ids = baseCondition.getId();
                    if (StrUtil.isNotEmpty(ids)) {
                        DaoUtil.addCondition(conditionSql, "IN", "id", ids, params);
                    }
                    String foreignKeyName = baseCondition.getForeignKeyName();
                    String foreignKeyValue = baseCondition.getForeignKeyValue();
                    for (TableConf conf : confs) {
                        String colOrmName = conf.getColumnOrmName();
                        if (!StrUtil.isNotEmpty(foreignKeyName) || !StrUtil.isNotEmpty(foreignKeyValue) || !foreignKeyName.equals(colOrmName)) continue;
                        DaoUtil.addCondition(conditionSql, "IN", foreignKeyName, foreignKeyValue, params);
                    }
                }
                if (entity != null) {
                    Field[] fields = ObjectUtil.getAllFields(entity.getClass());
                    for (int i = 0; i < fields.length; ++i) {
                        String checkVal;
                        String name = fields[i].getName();
                        String upperName = name.substring(0, 1).toUpperCase() + name.substring(1);
                        Method getMethod = null;
                        getMethod = entity.getClass().getMethod("get" + upperName, new Class[0]);
                        Object value = getMethod.invoke(entity, new Object[0]);
                        String string = checkVal = value != null ? String.valueOf(value) : null;
                        if (!StrUtil.isNotEmpty(checkVal) || name.equals("id")) continue;
                        List tcSelected = confs.stream().filter(o -> o.getColumnOrmName().equals(name)).collect(Collectors.toList());
                        TableConf conf = null;
                        if (!ArrayUtil.isNotEmpty(tcSelected)) continue;
                        conf = (TableConf)tcSelected.get(0);
                        DaoUtil.addCondition(conditionSql, conf.getSqlSpellMode(), name, value, params);
                    }
                }
            }
            catch (Exception e) {
                throw new ResultException(ResCode.SERVER_COMMON_ERROR);
            }
        }
        return conditionSql.toString();
    }

    private static void addCondition(StringBuffer sql, String sqlSpellMode, String propName, Object value, Map<String, Object> params) {
        if (propName.equals("id") || propName.contains("Id")) {
            List<Integer> intVals = StrUtil.ids2IntList(value.toString());
            sql.append(" and ").append(propName).append(" in (:").append(propName).append(")");
            params.put(propName, intVals);
        } else if (sqlSpellMode.equalsIgnoreCase("EQ")) {
            sql.append(" and ").append(propName).append(" = :").append(propName);
            params.put(propName, value.toString());
        } else if (sqlSpellMode.equalsIgnoreCase("LIKE")) {
            sql.append(" and ").append(propName).append(" like :").append(propName);
            params.put(propName, value.toString());
        } else if (sqlSpellMode.equalsIgnoreCase("IN")) {
            String className = value.getClass().getName();
            System.out.println(className);
            switch (className) {
                case "java.lang.String": {
                    List<String> StringVals = StrUtil.ids2StringList(value.toString());
                    sql.append(" and ").append(propName).append(" in (:").append(propName).append(")");
                    params.put(propName, StringVals);
                    break;
                }
                case "java.lang.Integer": 
                case "java.lang.Double": 
                case "java.lang.Float": 
                case "java.lang.Long": 
                case "java.lang.Short": 
                case "java.lang.Byte": 
                case "java.math.BigDecimal": {
                    List<Integer> intVals = StrUtil.ids2IntList(value.toString());
                    sql.append(" and ").append(propName).append(" in (:").append(propName).append(")");
                    params.put(propName, intVals);
                    break;
                }
            }
        }
    }
}

