/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.base.dao;

import cn.warpin.core.base.condition.BaseCondition;
import cn.warpin.core.base.condition.QueryCondition;
import cn.warpin.core.base.dao.DaoUtil;
import cn.warpin.core.base.tableConf.bean.TableConf;
import cn.warpin.core.database.redis.RedisOperate;
import cn.warpin.core.result.Result;
import cn.warpin.core.util.ArrayUtil;
import cn.warpin.core.util.StrUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class CommonRepository {
    @PersistenceContext
    private EntityManager entityManager;

    public List<TableConf> queryTableConf(String pkg) {
        Map<String, String> map = RedisOperate.getMapValue("table_conf");
        String json = map.get(pkg);
        return (List)new Gson().fromJson(json, new TypeToken<List<TableConf>>(this){}.getType());
    }

    public Result query(QueryCondition queryCondition, String pkg) {
        BaseCondition baseCondition = queryCondition.getBaseCondition();
        List<TableConf> confs = this.queryTableConf(pkg);
        if (ArrayUtil.isEmpty(confs)) {
            return Result.success();
        }
        TableConf conf = confs.get(0);
        String entityName = conf.getEntityName();
        StringBuilder hql = new StringBuilder("FROM " + entityName + " WHERE 1=1 ");
        HashMap<String, Object> params = new HashMap<String, Object>();
        String exConditionHQL = DaoUtil.setExternalCondition(queryCondition, confs, params);
        hql.append(exConditionHQL);
        if (baseCondition != null && StrUtil.isNotEmpty(baseCondition.getOderByFieldName()) && StrUtil.isNotEmpty(baseCondition.getOderByOption())) {
            hql.append(" order by ").append(baseCondition.getOderByFieldName()).append(" ").append(baseCondition.getOderByOption());
            hql.append(",id ").append(baseCondition.getOderByOption());
        } else {
            hql.append(" order by createdAt DESC");
        }
        Integer totalCount = null;
        int totalPage = 1;
        Query query = this.entityManager.createQuery(hql.toString());
        this.setParameters(query, confs, params);
        if (baseCondition != null && baseCondition.getPage() != null && baseCondition.getLimit() != null) {
            int beginIndex = (baseCondition.getPage() - 1) * baseCondition.getLimit();
            query.setFirstResult(beginIndex);
            query.setMaxResults(baseCondition.getLimit().intValue());
        }
        List queryList = query.getResultList();
        if (baseCondition != null && baseCondition.getPage() != null && baseCondition.getLimit() != null) {
            totalCount = this.count(queryCondition, confs, entityName, exConditionHQL, params);
            totalPage = (totalCount + baseCondition.getLimit() - 1) / baseCondition.getLimit();
        } else {
            totalCount = queryList.size();
        }
        return Result.querySuccess(queryList, totalCount.intValue(), totalPage);
    }

    public int count(QueryCondition queryCondition, List<TableConf> confs, String tableName, String exConditionHQL, Map<String, Object> params) {
        StringBuilder hql = new StringBuilder("SELECT count(id) FROM " + tableName + " WHERE 1=1 ");
        if (StrUtil.isEmpty(exConditionHQL) && !confs.isEmpty()) {
            params = new HashMap<String, Object>();
            exConditionHQL = DaoUtil.setExternalCondition(queryCondition, confs, params);
        }
        hql.append(exConditionHQL);
        Query query = this.entityManager.createQuery(hql.toString());
        this.setParameters(query, confs, params);
        List list = query.getResultList();
        return ((Long)list.get(0)).intValue();
    }

    private void setParameters(Query query, List<TableConf> tableConfs, Map<String, Object> params) {
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getValue() == null) continue;
            String key = entry.getKey();
            if ("id".equalsIgnoreCase(key)) {
                query.setParameter(entry.getKey(), entry.getValue());
                continue;
            }
            TableConf tc = tableConfs.stream().filter(o -> o.getColumnOrmName().equals(key)).toList().get(0);
            if (tc.getSqlSpellMode().equalsIgnoreCase("LIKE")) {
                query.setParameter(entry.getKey(), (Object)("%" + entry.getValue().toString() + "%"));
                continue;
            }
            query.setParameter(entry.getKey(), entry.getValue());
        }
    }
}

