/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.base.dao;

import cn.warpin.core.util.ArrayUtil;
import cn.warpin.core.util.StrUtil;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class BaseDao {
    @PersistenceContext
    private EntityManager entityManager;

    public void update(String EntityName, Object object, String conditionName) {
        boolean firstTime = true;
        StringBuffer sql = new StringBuffer("update " + EntityName + " set ");
        String name = "";
        Object upperName = "";
        String conditionValue = "";
        try {
            ArrayList<Field> fieldList = new ArrayList<Field>();
            for (Class<?> tempClass = object.getClass(); tempClass != null; tempClass = tempClass.getSuperclass()) {
                fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
            }
            Field[] fields = fieldList.toArray(new Field[fieldList.size()]);
            HashMap<String, Object> params = new HashMap<String, Object>();
            for (Field item : fields) {
                name = item.getName();
                upperName = name.substring(0, 1).toUpperCase() + name.substring(1);
                Method getMethod = object.getClass().getMethod("get" + (String)upperName, new Class[0]);
                Object value = getMethod.invoke(object, new Object[0]);
                params.put(name, value);
                if (name.equals(conditionName) || null == value || "".equals(value)) continue;
                sql.append(firstTime ? " " : ", ");
                firstTime = false;
                sql.append(name).append(" = ").append(":").append(name);
            }
            sql.append(" where ").append(conditionName).append("=").append(":").append(conditionName);
            Query query = this.entityManager.createQuery(sql.toString());
            for (Map.Entry entry : params.entrySet()) {
                if (entry.getValue() == null || "".equals(entry.getValue())) continue;
                query.setParameter((String)entry.getKey(), entry.getValue());
            }
            query.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void updateByMultiCondition(String EntityName, Map<String, Object> param, Map<String, Object> condition) {
        String val;
        Object value;
        String key;
        StringBuffer sql = new StringBuffer("update " + EntityName + " set ");
        int index = 0;
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            val = StrUtil.specialCharHandleForDB(value.toString());
            sql.append(index == 0 ? key + "='" + String.valueOf(value) + "'" : ", " + key + "='" + val + "'");
            ++index;
        }
        sql.append(" where ");
        index = 0;
        for (Map.Entry<String, Object> entry : condition.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            val = StrUtil.specialCharHandleForDB(value.toString());
            sql.append(index == 0 ? key + "='" + String.valueOf(value) + "'" : " and " + key + "='" + val + "'");
            ++index;
        }
        Query query = this.entityManager.createNativeQuery(sql.toString());
        query.executeUpdate();
    }

    public void updateCount(String EntityName, Object object, String conditionName) throws Exception {
        boolean firstTime = true;
        StringBuffer sql = new StringBuffer("update " + EntityName + " set ");
        String name = "";
        Object upperName = "";
        String conditionValue = "";
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> tempClass = object.getClass(); tempClass != null; tempClass = tempClass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        Field[] field = fieldList.toArray(new Field[fieldList.size()]);
        for (int i = 0; i < field.length; ++i) {
            name = field[i].getName();
            upperName = name.substring(0, 1).toUpperCase() + name.substring(1);
            Method getMethod = object.getClass().getMethod("get" + (String)upperName, new Class[0]);
            Object value = getMethod.invoke(object, new Object[0]);
            if (name.equals(conditionName)) {
                conditionValue = value.toString();
                continue;
            }
            if (null == value) continue;
            sql.append(firstTime ? " " : ",");
            firstTime = false;
            sql.append(name + "=" + name + "+" + String.valueOf(value));
        }
        sql.append(" where " + conditionName + "='" + conditionValue + "'");
        Query query = this.entityManager.createNativeQuery(sql.toString());
        query.executeUpdate();
    }

    public void updateIN(String EntityName, Object object, String conditionName, List idList, boolean isString) throws Exception {
        String conditionValue = StrUtil.idList2Str(idList, isString);
        if (StrUtil.isEmpty(conditionValue)) {
            return;
        }
        boolean firstTime = true;
        StringBuffer sql = new StringBuffer("update " + EntityName + " set ");
        String name = "";
        Object upperName = "";
        Field[] field = object.getClass().getDeclaredFields();
        for (int i = 0; i < field.length; ++i) {
            name = field[i].getName();
            upperName = name.substring(0, 1).toUpperCase() + name.substring(1);
            Method getMethod = object.getClass().getMethod("get" + (String)upperName, new Class[0]);
            Object value = getMethod.invoke(object, new Object[0]);
            if (null == value || "".equals(value)) continue;
            sql.append(firstTime ? " " : ",");
            firstTime = false;
            sql.append(name + "='" + value.toString() + "'");
        }
        sql.append(" where " + conditionName + " in (" + conditionValue + ")");
        Query query = this.entityManager.createNativeQuery(sql.toString());
        query.executeUpdate();
    }

    public void batchDelete(String[] idArray, String EntityName, String conditionName) {
        StringBuffer sql = new StringBuffer("delete from " + EntityName);
        if (null != idArray && idArray.length > 0) {
            sql.append(" where ");
            for (int i = 0; i < idArray.length; ++i) {
                sql.append(i == 0 ? conditionName + " = '" + idArray[i] + "'" : " or " + conditionName + " = '" + idArray[i] + "'");
            }
        }
        Query query = this.entityManager.createNativeQuery(sql.toString());
        query.executeUpdate();
    }

    public void batchDeleteByMultiCondition(String EntityName, Map<String, Object> param) {
        StringBuffer sql = new StringBuffer("delete from " + EntityName + " where ");
        int index = 0;
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            sql.append(index == 0 ? key + " = '" + String.valueOf(value) + "'" : " and " + key + " = '" + String.valueOf(value) + "'");
            ++index;
        }
        Query query = this.entityManager.createNativeQuery(sql.toString());
        query.executeUpdate();
    }

    public Integer count(String EntityName, Object object, String countName, String conditionName) throws Exception {
        Query query;
        List countList;
        Integer countNum = 0;
        StringBuffer sql = new StringBuffer("select COUNT(" + countName + ") from " + EntityName);
        if (StrUtil.isNotEmpty(conditionName)) {
            String name = "";
            Object upperName = "";
            String conditionValue = "";
            ArrayList<Field> fieldList = new ArrayList<Field>();
            for (Class<?> tempClass = object.getClass(); tempClass != null; tempClass = tempClass.getSuperclass()) {
                fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
            }
            Field[] field = fieldList.toArray(new Field[fieldList.size()]);
            for (int i = 0; i < field.length; ++i) {
                name = field[i].getName();
                upperName = name.substring(0, 1).toUpperCase() + name.substring(1);
                Method getMethod = object.getClass().getMethod("get" + (String)upperName, new Class[0]);
                Object value = getMethod.invoke(object, new Object[0]);
                if (!name.equals(conditionName)) continue;
                conditionValue = value.toString();
                break;
            }
            sql.append(" where " + conditionName + "='" + conditionValue + "'");
        }
        if (ArrayUtil.isNotEmpty(countList = (query = this.entityManager.createNativeQuery(sql.toString())).getResultList())) {
            countNum = Integer.valueOf(countList.get(0).toString());
        }
        return countNum;
    }

    public Integer count(String EntityName, String countName, Map<String, Object> conditionParam) {
        Integer countNum = 0;
        StringBuffer sql = new StringBuffer("select COUNT(" + countName + ") from " + EntityName + " where ");
        int index = 0;
        for (Map.Entry<String, Object> entry : conditionParam.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            sql.append(index == 0 ? key + " = '" + String.valueOf(value) + "'" : " and " + key + " = '" + String.valueOf(value) + "'");
            ++index;
        }
        Query query = this.entityManager.createNativeQuery(sql.toString());
        List countList = query.getResultList();
        if (ArrayUtil.isNotEmpty(countList)) {
            countNum = Integer.valueOf(countList.get(0).toString());
        }
        return countNum;
    }

    public BigDecimal sum(String EntityName, String countName, Map<String, Object> conditionParam) {
        BigDecimal sumNum = new BigDecimal("0.00");
        StringBuffer sql = new StringBuffer("select SUM(" + countName + ") from " + EntityName + " where ");
        int index = 0;
        for (Map.Entry<String, Object> entry : conditionParam.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            sql.append(index == 0 ? key + " like '" + String.valueOf(value) + "'" : " and " + key + " like '" + String.valueOf(value) + "'");
            ++index;
        }
        Query query = this.entityManager.createNativeQuery(sql.toString());
        List countList = query.getResultList();
        if (ArrayUtil.isNotEmpty(countList)) {
            sumNum = BigDecimal.valueOf(Double.valueOf(countList.get(0) == null ? "0.00" : countList.get(0).toString()));
        }
        return sumNum;
    }
}

