package cn.warpin.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;


public class GenUtils {

    /**
     * 将字符串的首字母转大写
     *
     * @param str 需要转换的字符串
     * @return 转换后的字母
     */
    public static String upperCaseFirstName(String str) {
        // 进行字母的ascii编码前移，效率要高于截取字符串进行转换的操作
        char[] cs = str.toCharArray();
        if (Character.isUpperCase(cs[0])) {
            return str;
        }
        cs[0] -= 32;
        return String.valueOf(cs);
    }

    /**
     * 将字符串的首字母转小写
     *
     * @param str 需要转换的字符串
     * @return 转换后的字母
     */
    public static String lowerCaseFirstName(String str) {
        // 进行字母的ascii编码前移，效率要高于截取字符串进行转换的操作
        char[] cs = str.toCharArray();
        if (Character.isLowerCase(cs[0])) {
            return str;
        }
        cs[0] += 32;
        return String.valueOf(cs);
    }

    /**
     * 将大写字母改为 _小写
     *
     * @param param
     * @return
     */
    public static String upperCharToUnderLine(String param) {
        Pattern p = Pattern.compile("[A-Z]");
        if (param == null || param.equals("")) {
            return "";
        }
        StringBuilder builder = new StringBuilder(param);
        Matcher mc = p.matcher(param);
        int i = 0;
        while (mc.find()) {
            builder.replace(mc.start() + i, mc.end() + i, "_" + mc.group().toLowerCase());
            i++;
        }

        if ('_' == builder.charAt(0)) {
            builder.deleteCharAt(0);
        }
        return builder.toString();
    }

    /**
     * java 对象是去掉表前缀的，因此第一个_左边的内容要删除掉
     * 将下划线转换为空格 并执行 java对象命名规则
     *
     * @param tableName   数据库表名
     * @param upCaseFirst 首字母是否大写
     * @return java对象名
     */
    public static String transformTableName(String tableName, boolean upCaseFirst) {

        // 格式化类型，要把表名前缀去掉
        String name = "";
        int index = tableName.toString().indexOf('_');
        if (index != -1) {
            name = tableName.toString().substring(index + 1);
        }
        return StrUtil.transformName(name, upCaseFirst);
    }


}
