package cn.warpin.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckUtil {

    // 判断是否是手机
    public static boolean isValidPhoneNumber(String phoneNumber) {
        // 定义中国大陆手机号的正则表达式
        String regex = "^(13[0-9]|14[579]|15[0-3,5-9]|16[6]|17[0135678]|18[0-9]|19[89])\\d{8}$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(phoneNumber);
        return matcher.matches();
    }

    // 判断是否是身份证号
    public static boolean isValidIDCard(String idCardNumber) {
        // 定义中国大陆身份证号的正则表达式
        String regex = "^(\\d{15}$|^\\d{18}$|^\\d{17}(\\d|X|x))$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(idCardNumber);
        return matcher.matches();
    }


    // 判断是否是邮箱
    public static boolean isValidEmail(String email) {
        // 定义邮箱地址的正则表达式
        String regex = "^[A-Za-z0-9+_.-]+@(.+)$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(email);
        return matcher.matches();
    }

    // 正则校验是否位6-10位的数字，用于校验员工工号
    public static boolean checkEmpCode(String code, String... cap) {
        String start = "6";
        String end = "10";
        if (cap != null && cap.length > 0) {
            for (int i = 0; i < cap.length; i++) {
                switch (i) {
                    case 0:
                        start = cap[0];
                        break;
                    case 1:
                        end = cap[1];
                        break;
                }
            }
        }
        String regex = "^\\d{" + start + "," + end + "}$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(code);
        return matcher.matches();
    }


}
