package cn.warpin.core.util;

import cn.warpin.core.exception.ResultException;
import cn.warpin.core.result.ResCode;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.lang.reflect.Method;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;


public class ArrayUtil {

    public static boolean isEmpty(List list) {
        return list == null || list.size() == 0;
    }

    public static boolean isNotEmpty(List list) {
        return list != null && list.size() > 0;
    }

    /**
     * 删除ArrayList中重复元素，保持顺序
     *
     * @param list
     */
    public static List removeDuplicateWithOrder(List list) {
        Set set = new HashSet();
        List newList = new ArrayList();
        for (Iterator iter = list.iterator(); iter.hasNext(); ) {
            Object element = iter.next();
            if (set.add(element)) newList.add(element);
        }
        return newList;
    }

    // 检查一个数是否在集合中
    public static Boolean checkNumberInArray(Integer number, List<Integer> numList) {
        if (ArrayUtil.isEmpty(numList)) {
            return false;
        }
        for (Integer num : numList) {
            if (number.equals(num)) {
                return true;
            }
        }
        return false;
    }

    /**
     * lambda表达式对象条件去重
     *
     * @param keyExtractor
     * @return
     */
    public static <T> List<T> removeDuplicatesByKey(List<T> list, Function<? super T, ?> keyExtractor) {
        Set<Object> seen = ConcurrentHashMap.newKeySet();
        Predicate<T> distinctByKey = t -> seen.add(keyExtractor.apply(t));
        return list.stream().filter(distinctByKey).toList();
    }


    /**
     * 对任何类型的 List 进行排序。
     *
     * @param list             要排序的列表
     * @param orderByFieldName 根据哪个字段名进行排序
     * @param orderByOption    排序选项，"ASC" 或 "DESC"
     * @param <T>              列表元素的类型
     */
    public static <T> void sortList(List<T> list, String orderByFieldName, String orderByOption) {
        if (list == null || orderByFieldName == null || orderByOption == null) {
            return;
        }

        // 构造 getter 方法名
        String methodName = "get" + orderByFieldName.substring(0, 1).toUpperCase() + orderByFieldName.substring(1);

        list.sort((o1, o2) -> {
            try {
                // 获取 getter 方法
                Method method = o1.getClass().getMethod(methodName);
                Comparable value1 = (Comparable) method.invoke(o1);
                Comparable value2 = (Comparable) method.invoke(o2);

                // 根据 orderByOption 进行比较
                return "ASC".equals(orderByOption) ? value1.compareTo(value2) : value2.compareTo(value1);
            } catch (Exception e) {
                throw new ResultException(ResCode.SERVER_COMMON_ERROR);
            }
        });
    }


}

@Data
@AllArgsConstructor
@NoArgsConstructor
class Gather {
    private String nodeId;
    private Integer rangeCount;
    private Long time;
}