package cn.warpin.core.security.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * 封装安全配置属性。
 */
@Data
@Component
@ConfigurationProperties(prefix = "security")
public class SecurityConfigProperties {

    /**
     * JWT配置信息。
     */
    private Jwt jwt;

    /**
     * 白名单列表。
     */
    private List<String> whiteList = new ArrayList<>();

    /**
     * JWT配置信息类。
     */
    @Data
    public static class Jwt {
        /**
         * 密钥。
         */
        private String secretKey;
        /**
         * 令牌过期时间。
         */
        private long expiration;
        /**
         * 刷新令牌配置信息。
         */
        private RefreshToken refreshToken;

        /**
         * 刷新令牌配置信息类。
         */
        @Data
        public static class RefreshToken {
            /**
             * 刷新令牌过期时间。
             */
            private long expiration;
        }
    }
}
