package cn.warpin.core.result;

/**
 * 定义系统响应码及对应的消息枚举。
 */
public enum ResCode {

    // 全局错误码
    SUCCESS("请求成功", 200),
    SERVER_COMMON_ERROR("服务器开小差啦,稍后再来试一试", 500),
    TOKEN_EXPIRE_ERROR("未获取授权", 401),
    ALREADY_LOGIN("未获取授权", 409),

    // CAS错误码
    INVALID_TICKET("没有服务票据或服务票据已失效", 1001),
    INVALID_TGT("无效的TGT", 1002),
    REGISTRY_SERVICE_FAIL("服务注册失败", 1003),
    INVALID_SERVICE_ID("无效的服务地址", 1004),

    REQUEST_PARAM_ERROR("参数错误", 100002),
    TOKEN_GENERATE_ERROR("生成token失败", 100004),
    DB_ERROR("数据库繁忙,请稍后再试", 100005),
    DB_UPDATE_AFFECTED_ZERO_ERROR("更新数据影响行数为0", 100006),
    NOT_EXIST("数据不存在", 100007),
    INCORRECT_PWD("密码不正确", 100008),
    INCORRECT_ACCOUNT("用户名不正确", 100009),
    INCORRECT_VERIFY_CODE("验证码不正确", 100010),
    UPLOAD_FILE_EMPTY("上传文件是空", 100011),
    FILE_NOT_EXIST("有文件不存在的情况", 100012),
    FILE_WRITE_FAIL("写出文件失败", 100013),
    UPLOAD_FILE_FAILED("上传文件失败", 100014),
    OUT_OF_RANGE("超出范围", 100015),
    PARSE_FILE_FAILED("解析文件失败", 100016),
    DB_INDEX_EXIST("数据库索引重复", 100017),

    // 系统模块
    SYS_EMP_NOT_EXIST("没有该员工", 200001),

    // 用户模块
    USER_EXIST("用户已存在", 300001),

    // 第三方业务码
    WX_USER_NOT_EXIST("微信登录AppId不存在", 400001),
    WX_USER_CHECK_FAILED("微信用户校验失败", 400002),
    WX_USER_LOGIN_FAILED("微信用户登录失败", 400003),

    SMS_SEND_FAILED("短信发送失败", 400021),
    SMS_CODE_INCORRECT("短信验证码错误", 400022),

    // 工单模块
    ORDER_NOT_EXIST("未找到相应的订单", 500001);

    /**
     * 错误码
     */
    private Integer key;

    /**
     * 错误消息
     */
    private String value;

    /**
     * 构造函数，初始化响应码和消息。
     *
     * @param value 错误消息
     * @param key   错误码
     */
    private ResCode(String value, Integer key) {
        this.value = value;
        this.key = key;
    }

    /**
     * 获取错误码。
     *
     * @return 错误码
     */
    public Integer getKey() {
        return key;
    }

    /**
     * 设置错误码。
     *
     * @param key 错误码
     */
    public void setKey(Integer key) {
        this.key = key;
    }

    /**
     * 获取错误消息。
     *
     * @return 错误消息
     */
    public String getValue() {
        return value;
    }

    /**
     * 设置错误消息。
     *
     * @param value 错误消息
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * 根据错误码获取对应的错误消息。
     *
     * @param key 错误码
     * @return 对应的错误消息
     */
    public static String getValueByKey(Integer key) {
        for (ResCode s : ResCode.values()) {
            if (s.getKey().equals(key)) {
                return s.getValue();
            }
        }
        return "";
    }

    /**
     * 根据匹配的错误消息获取对应的错误码。
     *
     * @param channelName 错误消息
     * @return 对应的错误码
     */
    public static Integer getKeyByValue(String channelName) {
        for (ResCode s : ResCode.values()) {
            if (channelName.equals(s.getValue())) {
                return s.getKey();
            }
        }
        return 0;
    }

    /**
     * 测试函数，打印成功响应的错误码和消息。
     */
    public static void main(String[] args) {
        Integer key = ResCode.SUCCESS.getKey();
        String val = ResCode.SUCCESS.getValue();

        System.out.printf("key:%s, value:%s ", key, val);

    }

}
