package cn.warpin.core.exception;

import cn.warpin.core.result.ResCode;
import cn.warpin.core.result.Result;
import com.alibaba.fastjson.JSONObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.MDC;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.HandlerMethod;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

@RestControllerAdvice
@CrossOrigin
@Slf4j
public class GlobalException {

    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    //日志追踪uuid
    public final static String LOGUUID = "logUUID";
    /**
     * 邮件推送频率限制
     */
    private static long pushTime = 0;


    /**
     * @name
     * @Description 全局异常拦截处理
     * @params
     * @time 18:42
     * @date 2018/5/7
     **/
    @ExceptionHandler(value = ResultException.class)
    public @ResponseBody
    Result exception(
            HttpServletRequest request,
            HttpServletResponse response,
            HandlerMethod o,
            Exception ex,
            ResultException resultException
    ) {
        //打印异常日志至控制台
        ex.printStackTrace();
        log.error("【全局异常】异常详细方法名称:{}", request.getServletPath());
        log.error("【全局异常】异常详细信息:{}", ex);
        log.error("【全局异常】异常信息errorMsg:{}", ex.getMessage());

        if (pushFrequency(30)) {
            log.info("发送异常邮件");
//            sendMessage(
//                    new String []{"654627623@qq.com","nhfaijbjynhobbda"},
//                    new String [] {"18860837104@163.com","670575109@qq.com"},
//                    "【"+ Constants.ENV+"-全局异常-"+o.getMethod().getName()+"】",
//                    emailContent(request,o,ex,null)
//            );
        } else {
            //仅打印错误信息到日志
            log.error("错误日志！error:{}", emailContent(request, o, ex, null));
        }

        // 没有结果集返回默认的
        if (resultException != null) {
            Result.fail(ResCode.SERVER_COMMON_ERROR, "未知错误");
        }

        return Result.fail(resultException.getCode(), resultException.getMsg());
    }


    /**
     * 整理出错栈信息
     */
    public static String errInfo(Exception e) {
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            // 将出错的栈信息输出到printWriter中
            e.printStackTrace(pw);
            pw.flush();
            sw.flush();
        } finally {
            if (sw != null) {
                try {
                    sw.close();
                } catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (pw != null) {
                pw.close();
            }
        }
        return sw.toString();
    }

    /**
     * 构造错误信息
     */
    public static String emailContent(
            HttpServletRequest request,
            HandlerMethod o,
            Exception ex,
            String[] customExMsg
    ) {
        //异常时间
        String time = sdf.format(new Date());
        //异常地址
        String url = request.getRequestURI();
        //请求方式
        String requestWay = request.getMethod();
        //请求方法
        String requestMethodName = o.getMethod().getName();
        StringBuffer sb = new StringBuffer();
        Class<?>[] methodClass = o.getMethod().getParameterTypes();
        for (Class<?> c : methodClass) {
            sb.append(c.getName() + ",");
        }
        //请求参数
        String params = getRequestParams(request);

        String html = "<!DOCTYPE html>\n" +
                "<html lang=\"en\">\n" +
                "<head>\n" +
                "<title>learn Resources</title>\n" +
                "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n" +
                "</head>\n" +
                "<body>\n" +
                "\n" +
                // body页面内容
                "%s" +
                "\n" +
                "</body>\n" +
                "</html>";

        StringBuffer sx = new StringBuffer();
        sx.append("<h3>请求地址:</h3>" + url + "");
        sx.append("<h3>请求方式:</h3>" + requestWay + "");
        sx.append("<h3>日志跟踪ID:</h3>" + MDC.get(LOGUUID) + "");
        sx.append("<h3>请求方法:</h3>" + (requestMethodName + "(" + sb.toString().substring(0, sb.toString().lastIndexOf(",")) + ")") + "");
        sx.append("<h3>请求参数:</h3>" + (StringUtils.isEmpty(params) ? "" : params) + "");
        sx.append("<h3>异常时间:</h3>" + time + "");
        if (!StringUtils.isEmpty(customExMsg)) {
            sx.append("<h3>自定义异常日志:</h3>code:" + customExMsg[0] + ";msg:" + customExMsg[1]);
        } else {
            sx.append("<h3>异常日志:</h3>" + (StringUtils.isEmpty(ex.getMessage()) ? "" : ex.getMessage()) + "");
        }
        sx.append("<h3>异常详细:</h3>" + errInfo(ex) + "");

        return String.format(html, sx);
    }

    public static String getUrl(
            HttpServletRequest request
    ) {
        String s = request.getRequestURI();
        String x = s.substring(s.indexOf("/") + 2);
        String url = x.substring(x.indexOf("/"));
        return url;
    }

    public static String getRequestParams(
            HttpServletRequest request
    ) {
        Map map = request.getParameterMap();
        if (map.size() == 0 && request.getContentType().equals("text/xml")) {
            map = (Map) request.getAttribute("paramValue");
        }

        /*Set keySet = map.entrySet();
        for(Iterator itr = keySet.iterator(); itr.hasNext();  ){
            Map.Entry me = (Map.Entry) itr.next();
            Object ok = me.getKey();
            Object ov = me.getValue();
            //System.out.println("ok:"+ok);
            //System.out.println("ov:"+ JSONObject.toJSONString(ov));
        }*/

        return JSONObject.toJSONString(map);
    }

    /**
     * @param seconds
     * @desc 推送邮件频率限制
     */
    public static boolean pushFrequency(Integer seconds) {
        if (pushTime != 0 && (System.currentTimeMillis() - pushTime) / 1000 >= seconds) {
            //重新赋值初始化时间
            pushTime = System.currentTimeMillis();

        } else if (pushTime == 0) {
            //程序第一次运行推送给时间赋值
            pushTime = System.currentTimeMillis();
        } else {
            //不在时间频率允许范围内，打印错误日志，不推送邮件
            return false;
        }

        return true;
    }


}
