package cn.warpin.core.constant;

/**
 * 存放一些常用的属性值，如布尔值、时间标识、登录类型等。
 */
public class Prop {

    /**
     * 布尔值
     */
    public static class Boolean {
        // 是
        public static final String YES = "1";
        // 否
        public static final String NO = "0";
    }

    /**
     * 时间标识
     */
    public static class TimeFlag {
        // 年
        public static final String YEAR = "YEAR";
        // 月
        public static final String MONTH = "MONTH";
        // 日
        public static final String DAY = "DAY";
    }

    /**
     * 登录类型
     */
    public static class LoginType {
        // 超级管理员
        public static final String ADMIN = "0";
        // 员工
        public static final String EMP = "1";
        // 用户
        public static final String USER = "2";
    }

    /**
     * 登录操作类型
     */
    public static class LoginOptType {
        // 密码登录
        public static final String PASSWORD = "0";
        // 手机登录
        public static final String CELL_PHONE = "1";
    }

    /**
     * OSS平台
     */
    public static class OssPlatform {
        // 本地
        public static final String LOCAL = "0";
        // 阿里
        public static final String ALI = "1";
        // 腾讯
        public static final String TENCENT = "2";
        // 华为
        public static final String HUAWEI = "3";
    }

    /**
     * 上传文件的业务类型
     */
    public static class UploadBizType {
        // 通用
        public static final String COMMON = "common";
        // 项目
        public static final String PROJECT = "project";
    }

    /**
     * 菜单类型
     */
    public static class MenuType {
        // 菜单
        public static final String MENU = "0";
        // 按钮
        public static final String BUTTON = "1";
        // 目录
        public static final String DIRECTORY = "2";
    }

    /**
     * SQL条件
     */
    public static class SqlMode {
        public static final String EQ = "EQ";   // 等于，默认值
        public static final String IN = "IN";   // SQL条件使用IN
        public static final String LT = "LT";   // 小于
        public static final String LE = "LE";   // 小于等于
        public static final String GT = "GT";   // 大于
        public static final String GE = "GE";   // 大于等于
        public static final String NOT = "NOT"; // 不等于
        public static final String LIKE = "LIKE";   // 模糊匹配
    }
}
