package cn.warpin.core.constant;

import lombok.Getter;

/**
 * 枚举类，存放一些常用的键值对，如登录类型、管理员账号密码等。
 */
@Getter
public enum EnumStore {

    // 登录类型
    LOGIN_TYPE_ADMIN("超级管理员访问", "0"),
    LOGIN_TYPE_EMP("员工访问", "1"),
    LOGIN_TYPE_USER("用户访问", "2"),

    // 管理员/员工登录账号密码
    ADMIN_ACCOUNT_1("超级管理员账号命名1", "admin"),
    ADMIN_ACCOUNT_2("超级管理员账号命名2", "administrator"),
    ADMIN_PASSWORD("超级管理员密码", "sadmin123456"),
    ADMIN_TEL("超级管理员电话", "18616786327"),
    EMP_DEFAULT_PASSWORD("员工默认密码", "000000"),

    // 各角色的token key
    CACHE_ADMIN_TOKEN_KEY("admin_token:", "0"),
    CACHE_EMP_TOKEN_KEY("emp_token:", "1"),
    CACHE_USER_TOKEN_KEY("user_token:", "2"),
    CACHE_TABLE_CONF_KEY("table_conf", "3"),

    // 保存token和version的key
    CACHE_TOKEN_KEY("token", "4"),
    CACHE_TOKEN_VERSION_KEY("version", "5"),

    // 保存通用设置的key
    COMMON_SETTING_KEY("common_setting", "6"),
    // 保存数据字典的key
    COMPONENT_OPTION_KEY("component_option", "7");


    private String key;
    private String value;

    private EnumStore(String value, String key) {
        this.value = value;
        this.key = key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(String value) {
        this.value = value;
    }

    /**
     * 根据key获取value的值
     *
     * @param key 键
     * @return 对应的值，若未找到则返回空字符串
     */
    public static String getValueByKey(String key) {
        for (EnumStore s : EnumStore.values()) {
            if (s.getKey().equals(key)) {
                return s.getValue();
            }
        }
        return "";
    }

    /**
     * 根据匹配value的值获取key
     *
     * @param channelName 要匹配的值
     * @return 匹配到的对应的键，若未找到则返回null
     */
    public static String getKeyByValue(String channelName) {
        for (EnumStore s : EnumStore.values()) {
            if (channelName.equals(s.getValue())) {
                return s.getKey();
            }
        }
        return null;
    }

}
