package cn.warpin.core.constant;


import lombok.Getter;

@Getter
public enum ApiList {
    // CAS注册服务
    CAS_REGISTER_SERVICE("CAS_REGISTER_SERVICE", "/v1/services"),
    // 获取TGT & ST
    CAS_GET_TGT_ST("CAS_GET_TGT", "/v1/tickets"),
    // 认证服务票据
    CAS_VALIDATE_ST("CAS_VALIDATE_ST", "/serviceValidate");

    private String key;
    private String value;

    private ApiList(String key, String value) {
        this.value = value;
        this.key = key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(String value) {
        this.value = value;
    }

    //根据key获取value的值
    public static String getValueByKey(String key) {
        for (ApiList s : ApiList.values()) {
            if (s.getKey().equals(key)) {
                return s.getValue();
            }
        }
        return "";
    }

    //根据匹配value的值获取key
    public static String getKeyByValue(String channelName) {
        for (ApiList s : ApiList.values()) {
            if (channelName.equals(s.getValue())) {
                return s.getKey();
            }
        }
        return "0";
    }

}
