package cn.warpin.core.base.tableConf.dao;

import cn.warpin.core.base.jpa.sql.SQLBuilder;
import cn.warpin.core.base.tableConf.bean.ColumnInfo;
import cn.warpin.core.base.tableConf.bean.TableInfo;
import cn.warpin.core.util.ArrayUtil;
import jakarta.annotation.Resource;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;

@Repository
public class TableConfRepository {


    @PersistenceContext
    private EntityManager entityManager;

    @Resource
    private SQLBuilder sqlBuilder;

    /**
     * 查询所有表信息
     *
     * @return
     */
    public List<TableInfo> queryAllTableInfo() {
        String sql = sqlBuilder.buildTableQuery();
        // 通过包名获取到实体类名称
        Query query = entityManager.createNativeQuery(sql.toString());
        // 获取结果集
        List<Object[]> queryList = query.getResultList();

        if (ArrayUtil.isEmpty(queryList)) {
            return null;
        }
        List<TableInfo> resultList = new ArrayList<>();
        for (Object[] objArr : queryList) {
            TableInfo tableInfo = new TableInfo(objArr);
            resultList.add(tableInfo);
        }

        return resultList;
    }

    /**
     * 查询所有列信息
     *
     * @return
     */
    public List<ColumnInfo> queryAllTableColumn() {
        String sql = sqlBuilder.buildColumnQuery();
        // 通过包名获取到实体类名称
        Query query = entityManager.createNativeQuery(sql);
        // 获取结果集
        List<Object[]> queryList = query.getResultList();

        if (ArrayUtil.isEmpty(queryList)) {
            return null;
        }
        List<ColumnInfo> resultList = new ArrayList<>();
        for (Object[] objArr : queryList) {
            ColumnInfo columnInfo = new ColumnInfo(objArr);
            resultList.add(columnInfo);
        }
        return resultList;
    }


}
