package cn.warpin.core.base.tableConf.bean;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class ColumnInfo {

    /**
     * 表名
     */
    private String TABLE_NAME;

    /**
     * 列名
     */
    private String COLUMN_NAME;

    /**
     * 列描述
     */
    private String COLUMN_COMMENT;

    /**
     * 类型
     */
    private String DATA_TYPE;

    /**
     * 表描述
     */
    private String TABLE_COMMENT;

    private Object dealWithNull(int index, boolean isInt) {
        if (isInt) {
            return 0;
        }
        return "";
    }

    public ColumnInfo(Object[] objArr) {
        Integer index = 0;
        this.TABLE_NAME = null != objArr[index] ? objArr[index++].toString() : (String) dealWithNull(++index, false);
        this.COLUMN_NAME = null != objArr[index] ? objArr[index++].toString() : (String) dealWithNull(++index, false);
        this.COLUMN_COMMENT = null != objArr[index] ? objArr[index++].toString() : (String) dealWithNull(++index, false);
        this.DATA_TYPE = null != objArr[index] ? objArr[index].toString() : (String) dealWithNull(++index, false);
    }


}
