package cn.warpin.core.util;

import cn.warpin.core.constant.Constants;
import org.apache.commons.lang3.RandomStringUtils;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;


public class StrUtil {

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !isEmpty(str);
    }


    // 生成uuid
    public static String uuid32() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String uuid36() {
        return UUID.randomUUID().toString();
    }

    /**
     * 生成随机key
     *
     * @param digitCapacity 生成key的位数，传0 默认是12位
     * @return
     */
    public static String randomKey(int digitCapacity) {
        if (digitCapacity == 0) {
            digitCapacity = 12;
        }
        String key = RandomStringUtils.randomAlphanumeric(digitCapacity).toUpperCase();
        return key;
    }


    public static String join(String[] strArr, String split) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strArr.length; i++) {
            if (i > 0) {
                sb.append(split);
            }
            sb.append(strArr[i]);
        }
        return sb.toString();
    }

    /**
     * 生成订单编号
     *
     * @return
     */
    public static String genOrderNum() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
        String formattedDateTime = now.format(formatter);
//        Random random = new Random();
//        int randDigit = random.nextInt(10);
        return formattedDateTime + randomKey(8);
    }

    public static String getNowStr() {
        Calendar now = Calendar.getInstance();
        StringBuffer sb = new StringBuffer();
        sb.append(now.get(Calendar.YEAR));
        sb.append(now.get(Calendar.MONTH) + 1);
        sb.append(now.get(Calendar.DAY_OF_MONTH));
        sb.append(now.get(Calendar.HOUR_OF_DAY));
        sb.append(now.get(Calendar.MINUTE));
        sb.append(now.get(Calendar.SECOND));
        sb.append(now.get(Calendar.MILLISECOND));
        return sb.toString();
    }

    public static List<Integer> ids2IntList(String ids) {
        List<Integer> list = new ArrayList<>();
        String[] arr = ids.split(",");
        for (String s : arr) {
            list.add(Integer.parseInt(s));
        }
        return list;
    }

    /**
     * 将字符串格式化成varchar形式
     *
     * @param ids
     * @return
     */
    public static String formatStringIDS(String ids) {
        List<String> idStringList = ids2StringList(ids);
        ids = idList2Str(idStringList, true);
        return ids;
    }

    public static List<String> ids2StringList(String ids) {
        List<String> list = new ArrayList<>();
        String[] arr = ids.split(",");
        for (String s : arr) {
            list.add(s);
        }
        return list;
    }

    // 将list转成字符串形式
    public static String idList2Str(List idList, boolean isVarchar) {
        String result = "";
        if (null == idList || idList.size() == 0) {
            return result;
        }
        for (int i = 0; i < idList.size(); i++) {
            if (isVarchar) {
                result += i == 0 ? "'" + idList.get(i) + "'" : Constants.SEPARATOR + "'" + idList.get(i) + "'";
            } else {
                result += i == 0 ? idList.get(i) : Constants.SEPARATOR + idList.get(i);
            }
        }

        return result;
    }

    /**
     * 格式化特殊字符（为数据库）
     *
     * @param text
     * @return
     */
    public static String specialCharHandleForDB(String text) {
        if (isEmpty(text)) {
            return "";
        }
        text = text.replace("'", "\\'");
        text = text.replace("\"", "\\\"");
        return text;
    }

    /**
     * 格式化key值
     *
     * @param key
     * @param prefix
     * @return
     */
    public static String fmtKey(String key, String prefix) {
        if (StrUtil.isNotEmpty(key)) {
            String newKey = key.toUpperCase();
            if (StrUtil.isNotEmpty(prefix) && !newKey.startsWith(prefix)) {
                return prefix + "_" + newKey;
            } else {
                return newKey;
            }
        } else {
            return null;
        }
    }

    // 自定义字符串替换
    public static String replace(String oldStr, String[] replaceStrArr, String tag) {
        String resStr = oldStr;
        for (int i = 0; i < replaceStrArr.length; i++) {
            int start = resStr.indexOf(tag);
            if (start == -1) {
                break;
            }
            int end = start + tag.length();
            StringBuilder sb = new StringBuilder(resStr);
            sb.replace(start, end, replaceStrArr[i]);
            resStr = sb.toString();
        }
        return resStr;
    }


    // 统计一个字符串再某字符串中出现的数量
    public static int getStrExistCount(String str, String inStr) {
        int count = (str.length() - str.replace(inStr, "").length()) / inStr.length();
        return count;
    }

//    public static void main(String[] args) {
//        System.out.println(getNowStr());
//    }


    //方法1：length为产生的位数
    public static String getRandomString(int length) {
        //定义一个字符串（A-Z，a-z，0-9）即62位；
        String str = "zxcvbnmlkjhgfdsaqwertyuiopQWERTYUIOPASDFGHJKLZXCVBNM1234567890";
        //由Random生成随机数
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        //长度为几就循环几次
        for (int i = 0; i < length; ++i) {
            //产生0-61的数字
            int number = random.nextInt(62);
            //将产生的数字通过length次承载到sb中
            sb.append(str.charAt(number));
        }
        //将承载的字符转换成字符串
        return sb.toString();
    }


    // 判断url是否是http开头
    public static Boolean checkUrlWithHttp(String url) {
        url = url.toLowerCase();
        if (url.startsWith("http") || url.startsWith("https")) {
            return true;
        }
        return false;
    }

    /**
     * 将字符串的首字母转大写
     *
     * @param str 需要转换的字符串
     * @return 转换后的字母
     */
    public static String upperCaseFirstName(String str) {
        // 进行字母的ascii编码前移，效率要高于截取字符串进行转换的操作
        char[] cs = str.toCharArray();
        if (Character.isUpperCase(cs[0])) {
            return str;
        }
        cs[0] -= 32;
        return String.valueOf(cs);
    }

    /**
     * 将字符串的首字母转小写
     *
     * @param str 需要转换的字符串
     * @return 转换后的字母
     */
    public static String lowerCaseFirstName(String str) {
        // 进行字母的ascii编码前移，效率要高于截取字符串进行转换的操作
        char[] cs = str.toCharArray();
        if (Character.isLowerCase(cs[0])) {
            return str;
        }
        cs[0] += 32;
        return String.valueOf(cs);
    }

    /**
     * 不光针对表，因此不会删除表前缀
     * 将下划线转换为空格 并执行 java对象命名规则
     *
     * @param name        数据库表名
     * @param upCaseFirst 首字母是否大写
     * @return java对象名
     */
    public static String transformName(String name, boolean upCaseFirst) {
        StringBuilder sb = new StringBuilder();
        String[] words = name.split("_");

        if (words.length > 0) {
            for (String word : words) {
                String captureName;
                if (!upCaseFirst) {
                    captureName = word;
                    upCaseFirst = true;
                } else {
                    captureName = upperCaseFirstName(word);
                }
                sb.append(captureName);
            }
            return sb.toString();
        }
        return words[0];
    }

    // 通过包名获取实体类名称
    public static String getEntityNameFromPkg(String pkg, Boolean lowerCase) {
        String[] arr = pkg.split("\\.");
        String eName = arr[arr.length - 1];
        if (lowerCase) {
            eName = lowerCaseFirstName(eName);
        }
        return eName;
    }


    /**
     * 阿拉伯数字金额转人民币大写
     *
     * @param amount
     */
    public static String amountToCH(String amount) {
        // 如果有小数点，需要将小数点后去除
        if (amount.contains(".")) {
            Double d = Double.parseDouble(amount);
            amount = d.intValue() + "";
        }

        //输出大写的数字金额，例如235元，输出贰佰叁拾伍元
        char[] arr1 = {'零', '壹', '贰', '叁', '肆', '伍', '陆', '柒', '捌', '玖'};
        char[] arr2 = {'零', '零', '零', '零', '零', '零', '零', '零'};
        //使用charAt()方法，得到字符串的一个字符数，将此字符数进行类型强制转换，再减去48，便可得到该字符数字对应的数字
        //得到字符数之后，便将此字符数作为arr1的下标，而后便获得该字符数对应的中文大写
        //将该中文大写字符替换arr2中的字符，7-str.length()+k获得每一次替换的下标
        for (int k = 0; k < amount.length(); k++) {
            arr2[8 - amount.length() + k] = arr1[(int) amount.charAt(k) - 48];
        }
        String result = "";
        for (int i = 0; i < arr2.length; i++) {
            if (arr2[i] == '零' && i < arr2.length - 1) {
                continue;
            }
            switch (i) {
                case 0:
                    result += arr2[i] + "仟";
                    break;
                case 1:
                    result += arr2[i] + "佰";
                    break;
                case 2:
                    result += arr2[i] + "拾";
                    break;
                case 3:
                    result += arr2[i] + "万";
                    break;
                case 4:
                    result += arr2[i] + "仟";
                    break;
                case 5:
                    result += arr2[i] + "佰";
                    break;
                case 6:
                    result += arr2[i] + "拾";
                    break;
                case 7:
                    char last = arr2[i];
                    if (last == '零') {
                        result += "圆";
                    } else {
                        result += arr2[i] + "圆";
                    }
                    break;
            }

        }
        return result;
        //输出所输入的阿拉伯数字的中文金额大写，这里最高设置成了百万，如果想增加金额上限，在arr2中多加入多个字符'零'即可
//        System.out.print("此数字转换为中文金额大写为：" + arr2[0] + "佰 " + arr2[1] + "拾 " + arr2[2] + "万 " + arr2[3] + "仟 " +
//                arr2[4] + "佰 " + arr2[5] + "拾 " + arr2[6] + "元");
    }

    /**
     * 阿拉伯数字转罗马数字
     *
     * @param num
     * @return
     */
    public static String intToRoman(int num) {
        HashMap<Integer, String> maps = new HashMap<>();
        maps.put(1, "I");
        maps.put(5, "V");
        maps.put(10, "X");//
        maps.put(50, "L");//
        maps.put(100, "C"); //
        maps.put(500, "D");//
        maps.put(1000, "M");//
        maps.put(4, "IV");
        maps.put(9, "IX");//
        maps.put(40, "XL");//
        maps.put(90, "XC");//
        maps.put(400, "CD");//
        maps.put(900, "CM");//
        String res = "";
        int[] digits = new int[13];
        digits[0] = 1000;
        digits[1] = 900;
        digits[2] = 500;
        digits[3] = 400;
        digits[4] = 100;
        digits[5] = 90;
        digits[6] = 50;
        digits[7] = 40;
        digits[8] = 10;
        digits[9] = 9;
        digits[10] = 5;
        digits[11] = 4;
        digits[12] = 1;
        while (num > 0) {
            for (int i = 0; i < digits.length; i++) {
                if (num >= digits[i]) {
                    res += maps.get(digits[i]);
                    num -= digits[i];
                    break;
                }
            }
        }
        return res;
    }

    /**
     * 替换占位符之间的内容，包括占位符
     *
     * @param source
     * @param rex
     * @param replace
     * @return
     */
    public static String getSurplusString(String source, String rex, String replace) {
        String res = "";
        int startIndex = source.indexOf(rex);
        if (startIndex != -1) {
            int endIndex = source.indexOf(rex, startIndex + 1);
            if (endIndex != -1) {
                String beforeStart = source.substring(0, startIndex + rex.length());
                String afterEnd = source.substring(endIndex);
                res = beforeStart + replace + afterEnd;
            } else {
                res = source;
            }
        } else {
            res = source;
        }

        String result = res.replace(rex, "");
        return result;
    }

    /**
     * 提取违反唯一约束错误信息关键字
     *
     * @param message
     * @return
     */
    public static String extractKeyFromErrorMessage(String message) {
        String key = null;
        if (message != null && message.contains("Duplicate entry")) {
            int startIndex = message.indexOf("key '") + 5;
            int endIndex = message.indexOf("'", startIndex);
            if (startIndex > 0 && endIndex > startIndex) {
                key = message.substring(startIndex, endIndex);
            }
        }
        return key;
    }


    public static void main(String[] args) {
        Map<String, Object> categoryTypeVO = new HashMap<>();
        categoryTypeVO.put("a", "1");
        categoryTypeVO.put("uniqueTag", "1");
        boolean b = StrUtil.isEmpty((String) categoryTypeVO.get("uniqueTag"));
        System.out.println(b);
    }

}
