package cn.warpin.core.util;


import org.apache.commons.lang3.StringUtils;

import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PortalUtil {

    // 格式化电话号码
    public static String formatPhoneNum(String phoneNum) {
        Pattern p2 = Pattern.compile("^((\\+{0,1}0{0,2}86){0,1})");
        Matcher m2 = p2.matcher(phoneNum);
        StringBuffer sb = new StringBuffer();
        while (m2.find()) {
            m2.appendReplacement(sb, "");
        }
        m2.appendTail(sb);
        return sb.toString().trim();
    }

    /**
     * 正则校验方法
     *
     * @param rule
     * @return
     */
    public static boolean regexCheck(String str, String rule) {
        Pattern p = Pattern.compile(rule);
        Matcher m = p.matcher(str);
        return m.matches();
    }


    // 编码文本
    public static String encodeText(String text) throws UnsupportedEncodingException {
        if (StrUtil.isEmpty(text)) {
            return null;
        }
        if (isBase64Regx(text)) {// 如果是base64加密后的，则不再加密
            return text;
        }
        final byte[] textByte = text.getBytes("UTF-8");
        final Base64.Encoder encoder = Base64.getEncoder();
        //编码
        final String encodedText = encoder.encodeToString(textByte);
        return encodedText;
    }

    // 解码文本
    public static String decodeText(String encodeText) throws UnsupportedEncodingException {
        if (StrUtil.isEmpty(encodeText)) {
            return null;
        }
        if (!isBase64Regx(encodeText)) {// 如果是没有base64加密，则不再解码
            return encodeText;
        }
        final Base64.Decoder decoder = Base64.getDecoder();
        //解码
        String decodeText = new String(decoder.decode(encodeText), "UTF-8");
        return decodeText;
    }


    private static boolean isBase64Regx(String str) {
        String base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        return Pattern.matches(base64Pattern, str);
    }

    private static boolean isBase64(String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        } else {
            if (str.length() % 4 != 0) {
                return false;
            }
            char[] strChars = str.toCharArray();
            for (char c : strChars) {
                if ((c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z') || (c >= '0' && c <= '9') || c == '+' || c == '/' || c == '=') {
                    continue;
                } else {
                    return false;
                }
            }
            return true;
        }
    }

    /**
     * 获取对象中某个属性的值，最终都转化成String类型
     *
     * @param columnName
     * @param obj
     * @return
     * @throws Exception
     */
    public static String getValueFromObjectProperty(String columnName, Object obj) throws Exception {
        Object propertyValue = ObjectUtil.getPropertyValue(obj, columnName);
        if (propertyValue == null) {
            return null;
        }
        return propertyValue.toString();
    }

    public static void main(String[] args) {
        String str = "作业票同步结束,成功1条,失败0条。作业票储存成功的作业票id有[12833a0c-54b3-48c2-86f7-96d0f195cc7e,23433a0c-54b3-48c2-86f7-96d0f195cc7e],失败的作业票id有[123,456,789]。 错误原因为[上传失败1，上传失败2，上传失败3]";
        PortalUtil pu = new PortalUtil();
        int capacity = 3;
        String[] res = new String[capacity];
        pu.extraResultFromStr(str, "[", "]", res, capacity);

        System.out.println("===================================");

        for (String s : res) {
            System.out.println(s);
        }


    }

    int index = 0;

    private void extraResultFromStr(String str, String startChar, String endChar, String[] res, int cap) {
        int endIndex = str.indexOf(endChar);
        String str2 = str.substring(endIndex + 1);
        String s1 = StringUtils.substringBetween(str, startChar, endChar);
        res[index] = s1;
        System.out.println("res" + index + " = " + s1);// 得到的字符串
        index++;
        if (str2.contains(startChar) && str2.contains(endChar)) {
            extraResultFromStr(str2, startChar, endChar, res, cap);
        }
        if (index == cap - 1) {
            return;
        }
    }


}
