package cn.warpin.core.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class Numbers {

    public static class HandleNumber {
        public static BigDecimal doubleToBigDecimal(Double d) {
            if (null == d) {
                return null;
            }
            BigDecimal bigDecimal = new BigDecimal(d.toString());
            return bigDecimal;
        }

        public static Long bigDecimalParseToLong(Object object) {
            if (null == object) {
                return null;
            }
            BigDecimal bigDecimal = new BigDecimal((BigInteger) object);

            Long longNum = bigDecimal.longValue();
            return longNum;
        }

        public static Integer bigDecimalParseToInteger(Object object) {
            if (null == object) {
                return null;
            }

            BigDecimal bigDecimal = new BigDecimal((Integer) object);

            Integer integerNum = bigDecimal.intValue();

            return integerNum;
        }

        public static Double bigDecimalParseToDouble(Object object) {
            if (null == object) {
                return 0.00;
            }

            BigDecimal bigDecimal = new BigDecimal((Double) object);

            Double integerNum = bigDecimal.doubleValue();

            return integerNum;
        }

        public static void main(String[] args) {
            double a = 1.2677149613739474E7;
            Double b = bigDecimalParseToDouble(a);
            System.out.println(b);
        }

        public static Double DoubleFix(Double d, Integer num) {
            if (d == null) {
                return null;
            }
            if (num == null) {
                return d;
            }
            BigDecimal b = new BigDecimal(d);
            d = b.setScale(num, BigDecimal.ROUND_HALF_UP).doubleValue();
            return d;
        }

    }

    final static char[] digits =
            {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd',
                    'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q',
                    'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D',
                    'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q',
                    'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    final static Map<Character, Integer> digitMap = new HashMap<Character, Integer>();

    static {
        for (int i = 0; i < digits.length; i++) {
            digitMap.put(digits[i], (int) i);
        }
    }

    /**
     * 支持的最大进制数
     */
    public static final int MAX_RADIX = digits.length;

    /**
     * 支持的最小进制数
     */
    public static final int MIN_RADIX = 2;

    /**
     * 将长整型数值转换为指定的进制数（最大支持62进制，字母数字已经用尽）
     *
     * @param i
     * @param radix
     * @return
     */
    public static String toString(long i, int radix) {
        if (radix < MIN_RADIX || radix > MAX_RADIX) radix = 10;
        if (radix == 10) return Long.toString(i);

        final int size = 65;
        int charPos = 64;

        char[] buf = new char[size];
        boolean negative = (i < 0);

        if (!negative) {
            i = -i;
        }

        while (i <= -radix) {
            buf[charPos--] = digits[(int) (-(i % radix))];
            i = i / radix;
        }
        buf[charPos] = digits[(int) (-i)];

        if (negative) {
            buf[--charPos] = '-';
        }

        return new String(buf, charPos, (size - charPos));
    }

    static NumberFormatException forInputString(String s) {
        return new NumberFormatException("For input string: \"" + s + "\"");
    }

    /**
     * 将字符串转换为长整型数字
     *
     * @param s     数字字符串
     * @param radix 进制数
     * @return
     */
    public static long toNumber(String s, int radix) {
        if (s == null) {
            throw new NumberFormatException("null");
        }

        if (radix < MIN_RADIX) {
            throw new NumberFormatException("radix " + radix
                    + " less than Numbers.MIN_RADIX");
        }
        if (radix > MAX_RADIX) {
            throw new NumberFormatException("radix " + radix
                    + " greater than Numbers.MAX_RADIX");
        }

        long result = 0;
        boolean negative = false;
        int i = 0, len = s.length();
        long limit = -Long.MAX_VALUE;
        long multmin;
        Integer digit;

        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Long.MIN_VALUE;
                } else if (firstChar != '+') throw forInputString(s);

                if (len == 1) {
                    throw forInputString(s);
                }
                i++;
            }
            multmin = limit / radix;
            while (i < len) {
                digit = digitMap.get(s.charAt(i++));
                if (digit == null) {
                    throw forInputString(s);
                }
                if (digit < 0) {
                    throw forInputString(s);
                }
                if (result < multmin) {
                    throw forInputString(s);
                }
                result *= radix;
                if (result < limit + digit) {
                    throw forInputString(s);
                }
                result -= digit;
            }
        } else {
            throw forInputString(s);
        }
        return negative ? result : -result;
    }

    /**
     * 生成短信验证码
     *
     * @return
     */
    public static String generateSMSCode() {
        Integer num = new Random().nextInt(899999) + 100000;
        return num.toString();
    }

    /**
     * 格式化分数
     *
     * @param value
     * @return
     */
    public static double formatScore(double value) {
        double result = 0.0;
        String var = value + "";
        int index = var.indexOf(".") + 1;
        int firstDigit = Integer.parseInt(var.substring(0, 1));
        String lastVar = var.substring(index, index + 1);
        int lastDigit = Integer.parseInt(lastVar);
        if (firstDigit >= 5) {
            result = 5.0;
        } else if (lastDigit > 5) {
            result = firstDigit + 1.0;
        } else if (lastDigit == 0) {
            result = firstDigit + 0.0;
        } else {
            result = firstDigit + 0.5;
        }
        return result;
    }

    /**
     * 生成员工工号
     *
     * @return
     */
    public static String generateEmpCode() {
        int min = 200100; // 设置随机数下限
        int max = 999999; // 设置随机数上限
        Random rand = new Random();
        int num = rand.nextInt(max - min - 1) + min + 1;
        return String.valueOf(num);
    }

}
