package cn.warpin.core.util;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import java.util.List;
import java.util.Map;

public class JsonUtil {
    public static Gson gs;

    static {
        gs = new Gson();
    }

    public static List<String> toListString(String jsonStr) {
        return gs.fromJson(jsonStr, new TypeToken<List<String>>() {
        }.getType());
    }

    public static List<Map> toListMap(String jsonStr) {
        return gs.fromJson(jsonStr, new TypeToken<List<Map>>() {
        }.getType());
    }

    public static String toJson(Object o) {
        if (o == null) {
            return null;
        }
        return gs.toJson(o);
    }

    public static <T> T toObject(String json, Class<T> clazz) {
        return gs.fromJson(json, clazz);
    }

    public static void main(String[] args) {
        String arr = "[\"com.dazz.pkg.user.User\", \"name\"]";
        List<String> s = toListString(arr);
        System.out.println(s);
    }

}
