package cn.warpin.core.util;


import com.alibaba.fastjson2.JSON;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.Base64;
import java.util.List;
import java.util.Map;

@Component
public class HttpUtil {

    private String authorizationHeader;

    /**
     * json请求
     *
     * @param restTemplate
     * @param content
     */
    public String postJson(RestTemplate restTemplate, String url, Object content) {
        // 设置HTTP请求头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (StrUtil.isNotEmpty(authorizationHeader)) {
            headers.set("Authorization", authorizationHeader);
        }
        // 构建服务注册的JSON数据
        String serviceData = JSON.toJSONString(content);
        // 创建HTTP请求实体
        HttpEntity<String> entity = new HttpEntity<>(serviceData, headers);
        // 发送POST请求注册服务
        String response = null;
        try {
            response = restTemplate.postForObject(url, entity, String.class);
        } catch (Exception e) {
            String errMsg = e.getMessage();
            throw new RuntimeException(errMsg);
        }

        // 打印响应
        System.out.println("==========请求地址==========> : \n" + url);
        System.out.println("==========请求结果==========> : \n" + response);
        return response;
    }

    /**
     * 带鉴权头的postJson
     *
     * @param restTemplate
     * @param url
     * @param content
     * @param username
     * @param password
     * @return
     */
    public String postJson(RestTemplate restTemplate, String url, Object content, String username, String password) {
        // 组合用户名和加密后的密码
        String credentials = username + ":" + password;
        // 使用Base64编码凭据
        String encodedCredentials = Base64.getEncoder().encodeToString(credentials.getBytes());
        authorizationHeader = "Basic " + encodedCredentials;
        return postJson(restTemplate, url, content);
    }

    /**
     * post form请求
     *
     * @param restTemplate
     * @param url
     * @param content
     * @return
     */
    public String postForm(RestTemplate restTemplate, String url, Object content) {
        // 设置HTTP请求头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        if (StrUtil.isNotEmpty(authorizationHeader)) {
            headers.set("Authorization", authorizationHeader);
        }
        MultiValueMap<String, String> map = ObjectUtil.transBean2MultiValueMap(content);
        // 创建HTTP请求实体
        HttpEntity<MultiValueMap<String, String>> entity = new HttpEntity<>(map, headers);

        // 发送POST请求
        String response = null;
        try {
            response = restTemplate.postForObject(url, entity, String.class);
        } catch (Exception e) {
            String errMsg = e.getMessage();
            throw new RuntimeException(errMsg);
        }

        // 打印响应
        System.out.println("==========请求地址==========> : \n" + url);
        System.out.println("==========请求结果==========> : \n" + response);
        return response;
    }

    /**
     * 带鉴权头的postForm
     *
     * @param restTemplate
     * @param url
     * @param content
     * @param username
     * @param password
     * @return
     */
    public String postForm(RestTemplate restTemplate, String url, Object content, String username, String password) {
        // 组合用户名和加密后的密码
        String credentials = username + ":" + password;
        // 使用Base64编码凭据
        String encodedCredentials = Base64.getEncoder().encodeToString(credentials.getBytes());
        authorizationHeader = "Basic " + encodedCredentials;
        return postForm(restTemplate, url, content);
    }

    /**
     * get 请求
     *
     * @param restTemplate
     * @param url
     * @param content
     * @return
     */
    public String get(RestTemplate restTemplate, String url, Object content) {
        // 构建URL并根据条件添加查询参数
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl(url);
        if (content != null) {
            // 先将content转换成map
            MultiValueMap<String, String> map = ObjectUtil.transBean2MultiValueMap(content);
            // 遍历Map中所有条目并将它们添加为查询参数
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                // 对于MultiValueMap中的每个键，可能有多个值，所以需要遍历值的列表
                for (String value : entry.getValue()) {
                    if (StrUtil.isNotEmpty(value)) {
                        builder.queryParam(entry.getKey(), value);
                    }
                }
            }
        }

        // 最终构建的URL
        String finalUrl = builder.toUriString();

        // 发送GET请求
        String response = null;
        try {
            response = restTemplate.getForObject(finalUrl, String.class);
        } catch (Exception e) {
            String errMsg = e.getMessage();
            throw new RuntimeException(errMsg);
        }

        // 打印响应
        System.out.println("==========请求地址==========> : \n" + finalUrl);
        System.out.println("==========请求结果==========> : \n" + response);

        return response;
    }


}

