package cn.warpin.core.exception;

import cn.warpin.core.result.ResCode;
import cn.warpin.core.result.Result;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 封装结果码和消息的自定义异常类。
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ResultException extends RuntimeException {

    /**
     * 错误码
     */
    private Integer code;

    /**
     * 错误消息
     */
    private String msg;

    /**
     * 使用指定的错误码和消息构造新的 ResultException。
     *
     * @param code 错误码
     * @param msg  错误消息
     */
    public ResultException(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    /**
     * 使用指定的 ResCode 枚举构造新的 ResultException。
     *
     * @param resCode ResCode 枚举
     */
    public ResultException(ResCode resCode) {
        this.code = resCode.getKey();
        this.msg = resCode.getValue();
    }

    /**
     * 使用指定的 ResCode 枚举和消息构造新的 ResultException。
     *
     * @param resCode ResCode 枚举
     * @param msg     错误消息
     */
    public ResultException(ResCode resCode, String msg) {
        this.code = resCode.getKey();
        this.msg = msg;
    }

    /**
     * 使用指定的 key 构造新的 ResultException。
     *
     * <p>
     * 它从 Result 成功响应中对应于 key 的消息中提取消息。
     * </p>
     *
     * @param key 从 Result 成功响应中提取消息的键
     */
    public ResultException(String key) {
        Result result = Result.success(key);
        this.code = result.getCode();
        this.msg = result.getMsg();
    }

}
