package cn.warpin.core.database.redis;

import cn.warpin.core.constant.Constants;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;

/**
 * RedisClient 的单例模式实现类，用于获取 RedisClient 实例。
 */
public class RedisClientSingleton {

    private static RedisClient redisClient;

    private RedisClientSingleton() {
        // 私有构造函数，防止外部创建实例
    }

    /**
     * 获取 RedisClient 实例的静态方法，实现懒加载。
     *
     * @return RedisClient 实例
     */
    public static synchronized RedisClient getRedisClient() {
        if (redisClient == null) {
            char[] pwdCharArray = Constants.REDIS_PWD.toCharArray();
            RedisURI redisUri = RedisURI.builder()
                    .withHost(Constants.REDIS_IP)
                    .withPort(Constants.REDIS_PORT)
                    .withDatabase(Constants.REDIS_DB_INDEX)
                    .withPassword(pwdCharArray)
                    .build();

            redisClient = RedisClient.create(redisUri);
        }
        return redisClient;
    }

    /**
     * 获取指定参数的 RedisClient 实例的静态方法。
     *
     * @param ip       Redis 服务器的 IP 地址
     * @param port     Redis 服务器的端口号
     * @param index    Redis 数据库索引
     * @param password Redis 密码
     * @return RedisClient 实例
     */
    public static synchronized RedisClient getRedisClient(String ip, int port, int index, String password) {
        if (redisClient == null) {
            char[] pwdCharArray = password.toCharArray();
            RedisURI redisUri = RedisURI.builder()
                    .withHost(ip)
                    .withPort(port)
                    .withDatabase(index)
                    .withPassword(pwdCharArray)
                    .build();

            redisClient = RedisClient.create(redisUri);
        }
        return redisClient;
    }


}
