package cn.warpin.core.constant;

/**
 * 存放一些标准命名规范，如反射包名前缀、实体类变量名称、范围查询后缀等。
 */
public class StandardName {

    /**
     * 用于反射时获取变量包名的前缀，如：pkg_users，在VO中返回的变量名称应为List<User> users。
     */
    public static final String REFLEXPKG = "pkg_";

    /**
     * 实体类变量名称为ID时，必须使用的名称。
     */
    public static final String ID = "id";

    /**
     * 实体类变量名称为create_at时，必须使用的名称。
     */
    public static final String CREATE_TIME = "create_at";

    /**
     * 拼接ID外键时的结尾，必须使用的名称。
     */
    public static final String Id = "Id";

    /**
     * 范围条件查询起始项后缀，_前面是实体类字段名称。
     */
    public static final String BEGIN = "_begin";

    /**
     * 范围条件查询结束项后缀，_前面是实体类字段名称。
     */
    public static final String END = "_end";

    /**
     * 定义实体类变量名称为父ID时，必须使用的名称。
     */
    public static final String PARENTID = "parentId";

    /**
     * 定义实体类变量名称为父ID时，必须使用的名称。
     */
    public static final String PARENT_ID = "parent_id";

    /**
     * 定义Condition中变量结尾，father表示查询类中的外键是父类，反之查询类的ID是其他类的外键。
     */
    public static final String FATHER = "father";

    /**
     * Redis key命名前缀，用于存放短信发送状态。
     */
    public static final String REDIS_SMS_KEY_PREFIX = "SMS_SENT_";
}
