package cn.warpin.core.constant;

/**
 * 存放系统中使用的各种常量值。
 */
public class Constants {
    /**
     * 运行环境的标识。
     */
    public static String ENV = "dev";

    /**
     * 目前只有一个服务，服务器类型为0。
     */
    public static String SERVERTYPE = "0";

    /**
     * 路径分隔符。
     */
    public static String PS = "/";

    /**
     * 域名。
     */
    public static String DOMAIN;

    /**
     * 品牌，阿里云上分目录。
     */
    public static String PROJECT;

    /**
     * CDN桶名。
     */
    public static String BUCKET;

    /**
     * CDN域名及上下文。
     */
    public static String RESOURCE_CONTEXT;

    /**
     * CDN域名。
     */
    public static String RESOURCE_DOMAIN;

    /**
     * 证书pdf地址。
     */
    public static String CERT_PDF_URL;

    /**
     * 地址上下文。
     */
    public static String CONTEXT;

    /**
     * API请求地址前缀。
     */
    public static String API_CONTEXT;

    /**
     * 资源路径。
     */
    public static String RESOURCE_PATH;

    /**
     * 动态库路径。
     */
    public static String LIB_PATH;

    /**
     * 数据库名称。
     */
    public static String DB_NAME = "test-spring3.0";

    /**
     * netty 监听ip。
     */
    public static String NETTY_IP = "127.0.0.1";

    /**
     * netty 监听端口。
     */
    public static String NETTY_PORT = "9080";

    /**
     * redis ip。
     */
    public static String REDIS_IP = "192.168.0.19";

    /**
     * redis port。
     */
    public static Integer REDIS_PORT = 6379;

    /**
     * redis port。
     */
    public static Integer REDIS_DB_INDEX = 2;

    /**
     * redis password。
     */
    public static String REDIS_PWD = "serveradmin";

    /**
     * 资源路径临时文件夹名称。
     */
    public static String RESOURCE_TEMP = "temp\\";

    /**
     * 用户默认密码。
     */
    public static String USER_DEFAULT_PWD = "123456";

    /**
     * 分隔符。
     */
    public static final String SEPARATOR = ",";

    /**
     * 分隔符。
     */
    public static final String SEPARATORLINE = "/";

    /**
     * 商品或套餐主图的最大上传数量。
     */
    public static final int MAXMAINIMGCOUNT = 20;

    /**
     * 商品或套餐描述图的最大上传数量。
     */
    public static final int MAXDESCIMGCOUNT = 20;

    /**
     * 商品或套餐轮播图的最大上传数量。
     */
    public static final int MAXDCARIMGCOUNT = 5;

    /**
     * 自动确认收货的天数。
     */
    public static final Long MAXCONFIRMDAY = 7L;

    /**
     * 指定使用的短信平台。"0": ali；"1": tencent。
     */
    public static final String SMSPLATFORM = "1";

    /**
     * 阿里云直接上传无包装。
     */
    public static final String UNPACKAGE = "0";

    /**
     * 包装后的图片服务器。
     */
    public static final String PACKAGE = "1";

    /**
     * 模板消息占位符。
     */
    public static final String PLACEHOLDER = "%s";

    /**
     * 本地oss目录。
     */
    public static final String local_path = "local-dev";

    /**
     * 开发目录。
     */
    public static final String dev_path = "online-test";

    /**
     * 正式目录。
     */
    public static final String pro_path = "online-pro";
}
