package cn.warpin.core.base.tableConf.dao;

import cn.warpin.core.base.jpa.sql.SQLBuilder;
import cn.warpin.core.base.tableConf.bean.ColumnInfo;
import cn.warpin.core.base.tableConf.bean.TableInfo;
import cn.warpin.core.util.ArrayUtil;
import cn.warpin.core.util.StrUtil;
import jakarta.annotation.Resource;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import org.springframework.stereotype.Repository;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import static cn.warpin.core.util.ObjectUtil.*;

@Repository
public class TableConfRepository {


    @PersistenceContext()
    private EntityManager entityManager;

    @Resource
    private SQLBuilder sqlBuilder;

    /**
     * 查询所有表信息
     *
     * @return
     */
    public List<TableInfo> queryAllTableInfo() {
        String sql = sqlBuilder.buildTableQuery();
        // 通过包名获取到实体类名称
        Query query = entityManager.createNativeQuery(sql.toString());
        // 获取结果集
        List<Object[]> queryList = query.getResultList();

        if (ArrayUtil.isEmpty(queryList)) {
            return null;
        }
        List<TableInfo> resultList = new ArrayList<>();
        for (Object[] objArr : queryList) {
            TableInfo tableInfo = new TableInfo(objArr);
            resultList.add(tableInfo);
        }

        return resultList;
    }

    /**
     * 查询所有列信息
     *
     * @return
     */
    public List<ColumnInfo> queryAllTableColumn() {
        String sql = sqlBuilder.buildColumnQuery();
        // 通过包名获取到实体类名称
        Query query = entityManager.createNativeQuery(sql);
        // 获取结果集
        List<Object[]> queryList = query.getResultList();

        if (ArrayUtil.isEmpty(queryList)) {
            return null;
        }
        List<ColumnInfo> resultList = new ArrayList<>();
        for (Object[] objArr : queryList) {
            ColumnInfo columnInfo = new ColumnInfo(objArr);


            String tableName = columnInfo.getTABLE_NAME();
            String cleanTableName = tableName.substring(tableName.indexOf("_") + 1);
            String targetClass = StrUtil.transformName(cleanTableName, true);
            String packageName = classFinder(targetClass);
            // 如果没有表注释，需要从代码注解中获取
            if (StrUtil.isEmpty(columnInfo.getTABLE_COMMENT())) {
                String tableComment = getClassTableComment(packageName);
                columnInfo.setTABLE_COMMENT(tableComment);
            }

            // 如果没有列注释，需要从代码注解中获取
            if (StrUtil.isEmpty(columnInfo.getCOLUMN_COMMENT())) {
                String fieldName = StrUtil.transformName(columnInfo.getCOLUMN_NAME(), false);
                String fieldComment = getFieldComment(packageName, fieldName);
                columnInfo.setCOLUMN_COMMENT(fieldComment);
            }
            resultList.add(columnInfo);
        }
        return resultList;
    }


    public static void main(String[] args) throws IOException {
        String packageName = "";
        String targetClass = "TestEntity";
        packageName = classFinder(targetClass);
        if (packageName != null && !packageName.isEmpty()) {
            System.out.println("Package name: " + packageName);
        } else {
            System.out.println("Class not found.");
        }

        // 使用完整的类路径替换 "your.package.TestEntity"
        String tableComment = getClassTableComment(packageName);
        System.out.println("Table Comment: " + tableComment);

        String fieldComment = getFieldComment(packageName, "testAge");
        System.out.println("Field Comment: " + fieldComment);


    }


}
