package cn.warpin.core.base.tableConf.bean;

import cn.warpin.core.base.baseEntity.BaseEntity;
import cn.warpin.core.base.jpa.jpaComment.annotation.ColumnComment;
import cn.warpin.core.base.jpa.jpaComment.annotation.TableComment;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import lombok.*;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;


/**
 * Summary :
 *
 * @author gyq
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "sys_table_conf")
@TableComment("表数据配置")
public class TableConf extends BaseEntity {
    /**
     * 字段名
     */
    @ColumnComment("字段名")
    @Column(length = 120)
    private String columnName;

    /**
     * 字段映射名
     */
    @ColumnComment("字段映射名")
    @Column(length = 120)
    private String columnOrmName;

    /**
     * 对应componentData返回数据中要显示的字段名称
     */
    @ColumnComment("对应componentData返回数据中要显示的字段名称")
    @Column(length = 80)
    private String componentLabel;

    /**
     * 对应componentData返回数据中要取值的字段名称
     */
    @ColumnComment("对应componentData返回数据中要取值的字段名称")
    @Column(length = 80)
    private String ComponentValue;

    /**
     * 字段中文描述
     */
    @ColumnComment("字段中文描述")
    @Column(length = 80)
    private String columnLabel;
    /**
     * 组件中的选项数据
     */
    @ColumnComment("组件中的选项外类型数据，选填远程请求地址")
    @Column(length = 80)
    private String componentData;

    /**
     * 组件中的选项类型数据，填选项父级标识
     */
    @ColumnComment("组件中的选项外类型数据，选填远程请求地址")
    @Column(length = 1024)
    private String optionData;

    /**
     * 组件类型
     */
    @ColumnComment("组件类型")
    @Column(length = 50)
    private String componentType;

    /**
     * 在编辑页中的位置
     */
    @ColumnComment("在编辑页中的位置")
    @Column(precision = 11)
    private Integer editPosition;

    /**
     * 编辑中是否显示
     */
    @ColumnComment("编辑中是否显示")
    @Column(length = 4)
    private String editShow;

    /**
     * 编辑中是否可编辑
     */
    @ColumnComment("编辑中是否可编辑")
    @Column(length = 4)
    private String editAble;

    /**
     * 编辑中为必填项
     */
    @ColumnComment("编辑中为必填项")
    @Column(length = 4)
    private String editRequired;

    /**
     * 在编辑页的组件宽度
     */
    @ColumnComment("在编辑页的组件宽度")
    @Column(precision = 11)
    private Integer editWidth;

    /**
     * sql拼接中是否忽略
     */
    @ColumnComment("sql拼接中是否忽略")
    @Column(length = 2)
    private String sqlIgnore;

    /**
     * sql拼接的类型，默认eq
     */
    @ColumnComment("sql拼接中是否忽略")
    @Column(length = 20)
    private String sqlSpellMode;

    /**
     * 表名
     */
    @ColumnComment("表名")
    @Column(length = 50)
    private String tableName;

    /**
     * 在表格中的宽度
     */
    @ColumnComment("在表格中的宽度")
    @Column(precision = 5, columnDefinition = "int default 180")
    private Integer tableWidth;

    /**
     * 表的中文描述
     */
    @ColumnComment("表的中文描述")
    @Column(length = 50)
    private String tableLabel;

    /**
     * 在表格中的位置
     */
    @ColumnComment("在表格中的位置")
    @Column(precision = 11, columnDefinition = "int default 9999")
    private Integer tablePosition;

    /**
     * 是否在表格中显示
     */
    @ColumnComment("是否在表格中显示")
    @Column(length = 2)
    private String tableShow;

    /**
     * 表格中是否可复制
     */
    @ColumnComment("表格中是否可复制")
    @Column(length = 2)
    private String copiable;


    /**
     * 实体类名称
     */
    @ColumnComment("实体类名称")
    @Column(length = 50)
    private String entityName;

    /**
     * 是否作为查询条件
     */
    @ColumnComment("是否作为查询条件")
    @Column(length = 2)
    private String beCondition;

    /**
     * 是否作为查询条件
     */
    @ColumnComment("查询条件的类型")
    @Column(length = 20)
    private String conditionType;

    /**
     * 查询条件为范围时的起始参数的名称
     */
    @ColumnComment("查询条件为范围时的起始参数的名称")
    @Column(length = 50)
    private String conditionRangeStartName;

    /**
     * 查询条件为范围时的结束参数的名称
     */
    @ColumnComment("查询条件为范围时的结束参数的名称")
    @Column(length = 50)
    private String conditionRangeEndName;

    /**
     * 实体类包路径
     */
    @ColumnComment("实体类包路径或表名")
    @Column(length = 120)
    private String pkg;


}

