package cn.warpin.core.base.service;

import cn.warpin.core.base.condition.BaseCondition;
import cn.warpin.core.base.condition.QueryCondition;
import cn.warpin.core.base.dao.CommonRepository;
import cn.warpin.core.constant.StandardName;
import cn.warpin.core.exception.ResultException;
import cn.warpin.core.result.ResCode;
import cn.warpin.core.result.Result;
import cn.warpin.core.util.ArrayUtil;
import cn.warpin.core.util.GenUtils;
import cn.warpin.core.util.ObjectUtil;
import cn.warpin.core.util.StrUtil;
import jakarta.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 通用服务类，提供通用的查询功能。
 */
@Service
public class CommonService {

    @Resource
    private CommonRepository repository;

    /**
     * 根据查询条件查询数据。
     *
     * @param condition 查询条件
     * @return 查询结果
     */
    public Result query(QueryCondition condition) {
        String pkg = (String) ObjectUtil.getPropertyValue(condition.getEntity(), "pkg");
        return repository.query(condition, pkg);
    }


    /**
     * 根据查询条件查询数据，并将结果包装成指定的VO对象。
     *
     * @param queryCondition 主类查询条件
     * @param mainClazzVO    主类的VO类，用于包装主类以及子类信息
     * @param voClassMap     要查询的子类，String为主类VO要赋值的属性名称，Class为要查询的子类
     * @return 查询结果
     */
    public Result queryVO(QueryCondition queryCondition, Class mainClazzVO, Map<String, Object> voClassMap) {
        Result mainResult = null;
        // 先构建一个主类VO对象的集合，作为返回对象
        List<Object> resultVOs = new ArrayList<>();
        String pkg = "";
        try {
            // 查询主表结果集
            pkg = (String) ObjectUtil.getPropertyValue(queryCondition.getEntity(), "pkg");
            mainResult = repository.query(queryCondition, pkg);
            List<?> resList = (List) mainResult.getRoot();
            if (ArrayUtil.isEmpty(resList)) {
                return mainResult;
            }
            List<Map<String, Object>> mainMapList = ObjectUtil.toListMap(resList);
            List<Integer> mainPrimaries = new ArrayList<>();
            for (Map<String, Object> map : mainMapList) {
                Integer id = (Integer) map.get("id");
                mainPrimaries.add(id);
            }


            BaseCondition subCondition = new BaseCondition();
            //  subCondition.setParentId(StrUtil.idList2Str(mainPrimaries, false));
            if (null == voClassMap || voClassMap.isEmpty()) {
                for (Object o : resList) {
                    Object targetO = mainClazzVO.getDeclaredConstructor().newInstance();
                    BeanUtils.copyProperties(o, targetO);
                    resultVOs.add(targetO);
                }
                mainResult.setRoot(resultVOs);
                return mainResult;
            }

            for (Map.Entry<String, Object> entry : voClassMap.entrySet()) {
                // 这里的key是condition中的参数名
                String conditionPropertyKey = entry.getKey();
                String[] endingWordArr = conditionPropertyKey.split("_");
                String endingWord = endingWordArr[endingWordArr.length - 1];
                Map<String, Object> classMap = (Map<String, Object>) entry.getValue();

                // 1.判断是查单条子类（子类id是该类的外键）
                if (endingWord.equals(StandardName.FATHER)) {
                    String propertyKey = "";
                    for (Map.Entry<String, Object> subEntry1 : classMap.entrySet()) {
                        if (!"pkg_val".equals(subEntry1.getKey())) {
                            propertyKey = subEntry1.getKey();
                        }
                    }
                    // Class propertyClass = subEntry1.getValue(); // 属性的类型，不是list，是item的类型
                    // 要获取到子类的id集合
                    // 拼接子类作为外键的属性名称，并从mainMapList每一个对象中得到子类外键id的值
                    List<Integer> ids = new ArrayList<>();
                    String keyName = propertyKey + StandardName.Id;
                    for (Map<String, Object> mainMap : mainMapList) {
                        if (null != mainMap.get(keyName) && !"".equals(mainMap.get(keyName).toString())) {
                            Integer id = Integer.parseInt(mainMap.get(keyName).toString());
                            ids.add(id);
                        }
                    }
                    BaseCondition subBaseCondition = new BaseCondition();
                    String idCondition = StrUtil.idList2Str(ids, false);
                    subBaseCondition.setId(idCondition);
                    QueryCondition subQueryCondition = new QueryCondition(subBaseCondition);
                    // 查询子结果集
                    String subPkg = (String) classMap.get("pkg_val");
                    Result fatherResult = repository.query(subQueryCondition, subPkg);
                    List<?> fatherRoot = (List<?>) fatherResult.getRoot();
                    if (ArrayUtil.isEmpty(fatherRoot)) {
                        continue;
                    }

                    for (int i = 0; i < mainMapList.size(); i++) {
                        Object primaryId = mainMapList.get(i).get(StandardName.ID);
                        Map<String, Object> resMap = getResultVO(primaryId.toString(), mainClazzVO, resultVOs);
                        boolean exist = (boolean) resMap.get("exist");
                        int index = (int) resMap.get("index");
                        Object resultVO = resMap.get("resultVO");
                        // 构建返回值item对象
                        // Object resultVO = mainClazzVO.newInstance(); 不能在这里构建，要看是否已构建过对象
                        // 将外键父类赋值给查询主类
                        String foreignId = mainMapList.get(i).get(keyName) != null ? mainMapList.get(i).get(keyName).toString() : null;
                        // 外键为空的情况时，需要构建一个结果对象，绑定给结果集
                        if (StrUtil.isEmpty(foreignId)) {
                            if (exist) {
                                resultVOs.set(index, resultVO);
                            } else {
                                BeanUtils.copyProperties(resList.get(i), resultVO);
                                resultVOs.add(resultVO);
                            }
                            continue;
                        }
                        // 子类结果集赋值给主类
                        List<Object> rootList = new ArrayList<>();

                        for (Object root : fatherRoot) {
                            // 获取父类的getMethod
                            Method getMethod = root.getClass().getMethod("get" + StandardName.Id);
                            // 关联类的主键id
                            Object itemValue = getMethod.invoke(root);
                            //  if (itemValue == null) {
                            //      continue;
                            //  }
                            String itemId = itemValue.toString();

                            if (foreignId.equals(itemId)) {
                                Method setMethodCurr = resultVO.getClass().getMethod("set" + StrUtil.upperCaseFirstName(propertyKey), List.class);
                                rootList.add(root);
                                setMethodCurr.invoke(resultVO, rootList);
                                break;
                            }
                        }

                        // 拷贝对象
                        if (exist) {
                            resultVOs.set(index, resultVO);
                        } else {
                            if (resultVO == null) {
                                resultVO = mainClazzVO.getDeclaredConstructor().newInstance();
                            }
                            BeanUtils.copyProperties(resList.get(i), resultVO);
                            resultVOs.add(resultVO);
                        }
                    }
                } else {// 2.判断是查该类作为其他类的外键id，其他类为该类的子类

                    String propertyKey = "";
                    String pkgVal = classMap.get("pkg_val") != null ? classMap.get("pkg_val").toString() : null;
                    //  Class propertyClass = null;

                    for (Map.Entry<String, Object> subEntry3 : classMap.entrySet()) {
                        if ("pkg_val".equals(subEntry3.getKey())) {
                            continue;
                        }
                        propertyKey = subEntry3.getKey();// 主类vo的属性名称
                        //  propertyClass = (Class) subEntry3.getValue(); // 属性的类型，不是list，是item的类型
                    }

                    String mainClassName = GenUtils.transformTableName(pkg, true);
                    // 这里不能全查，仅要根据外键查询,但不包含子项与父项为相同表时的情况，此时外键必定为parentId
                    String foreignKey = null;
                    if (!pkgVal.equals(pkg)) {
                        foreignKey = mainClassName + StandardName.Id;
                        foreignKey = GenUtils.lowerCaseFirstName(foreignKey);
                    } else {
                        foreignKey = StandardName.PARENTID;
                    }
                    subCondition.setForeignKeyName(foreignKey);
                    String foreignIds = StrUtil.idList2Str(mainPrimaries, false);
                    subCondition.setForeignKeyValue(foreignIds);

                    QueryCondition subQueryCondition = new QueryCondition(subCondition);
                    // 查询子项
                    Result subResult = repository.query(subQueryCondition, pkgVal);
                    List<?> subRoot = (List<?>) subResult.getRoot();
                    if (ArrayUtil.isEmpty(subRoot)) {
                        continue;
                    }
                    String upperName = StrUtil.upperCaseFirstName(propertyKey);// 将主类属性名称首字母转成大写，反射获取set方法
                    Method setMethod = mainClazzVO.getMethod("set" + upperName, List.class);// 获取原生类的get方法
                    // 将子类结果集转化成List<Map>
                    List<Map<String, Object>> subMapList = ObjectUtil.toListMap(subRoot);

                    for (int i = 0; i < mainMapList.size(); i++) {
                        Object primaryId = mainMapList.get(i).get(StandardName.ID);
                        Map<String, Object> resMap = getResultVO(primaryId.toString(), mainClazzVO, resultVOs);
                        boolean exist = (boolean) resMap.get("exist");
                        int index = (int) resMap.get("index");
                        Object resultVO = resMap.get("resultVO");
                        // 构建返回值item对象
                        // Object resultVO = mainClazzVO.newInstance();

                        Integer mainId = (Integer) mainMapList.get(i).get("id");
                        // 循环所有的子类结果集，如果父子id对应，包装在一个集合中,再赋值给对应的主类VO
                        List children = new ArrayList<>();

                        for (int j = 0; j < subMapList.size(); j++) {
                            // 这里要使用统一的命名规则，外键规则为表名（实体类名称）+ id 如：invitationCodeId
                            String eName = GenUtils.transformTableName(pkg, false); // 主类的属性，作为子类的外键
                            String colName = eName + StandardName.Id;
                            if (pkg.equals(pkgVal)) {
                                colName = StandardName.PARENTID;
                            }
                            if (subMapList.get(j).get(colName) == null) {
                                continue;
                            }
                            Integer subId = Integer.parseInt(subMapList.get(j).get(colName).toString());
                            if (mainId.equals(subId)) {
                                children.add(subRoot.get(j));
                                setMethod.invoke(resultVO, children);
                                // break;
                            }
                        }

                        // 拷贝对象
                        if (exist) {
                            resultVOs.set(index, resultVO);
                        } else {
                            if (resultVO == null) {
                                resultVO = mainClazzVO.getDeclaredConstructor().newInstance();
                            }
                            BeanUtils.copyProperties(resList.get(i), resultVO);
                            resultVOs.add(resultVO);
                        }

                    }
                }
            }

        } catch (Exception e) {
            throw new ResultException(ResCode.SERVER_COMMON_ERROR);
        }
        if (ArrayUtil.isNotEmpty(resultVOs)) {
            mainResult.setRoot(resultVOs);
        }
        return mainResult;
    }

    /**
     * 根据ID获取结果VO对象。
     *
     * @param id          ID值
     * @param mainClazzVO 主类的VO类
     * @param resultVOs   结果VO对象集合
     * @return 包含结果VO对象的Map
     * @throws Exception 反射相关异常
     */
    private Map<String, Object> getResultVO(String id, Class mainClazzVO, List<Object> resultVOs) throws Exception {
        Map<String, Object> resMap = new HashMap<>();
        boolean exist = false;
        Object resultVO = null;
        int index = 0;
        for (Object res : resultVOs) {
            Object value = ObjectUtil.getPropertyValue(res, StandardName.ID);
            if (value.toString().equals(id)) {
                resultVO = res;
                exist = true;
                break;
            }
            index++;
        }
        if (resultVO == null) {
            resultVO = mainClazzVO.newInstance();
        }
        resMap.put("exist", exist);
        resMap.put("index", index);
        resMap.put("resultVO", resultVO);
        return resMap;
    }


}
