package cn.warpin.core.base.jpa.jpaStrategy;

import com.google.common.base.CaseFormat;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.PhysicalNamingStrategyStandardImpl;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;

/**
 * 自定义物理命名策略，将驼峰命名转换为下划线命名。
 */
public class CustomPhysicalNamingStrategy extends PhysicalNamingStrategyStandardImpl {

    /**
     * 将驼峰命名的列名转换为下划线命名。
     *
     * @param name    列名标识符
     * @param context JDBC 环境
     * @return 转换后的物理列名标识符
     */
    @Override
    public Identifier toPhysicalColumnName(Identifier name, JdbcEnvironment context) {
        String columnName = name.getText();
        String snakeCaseColumnName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, columnName);
        snakeCaseColumnName = snakeCaseColumnName.toLowerCase();
        return Identifier.toIdentifier(snakeCaseColumnName);
    }

    /**
     * 将驼峰命名的表名转换为下划线命名。
     *
     * @param name    表名标识符
     * @param context JDBC 环境
     * @return 转换后的物理表名标识符
     */
    @Override
    public Identifier toPhysicalTableName(Identifier name, JdbcEnvironment context) {
        String tableName = name.getText();
        String snakeCaseTableName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, tableName);
        snakeCaseTableName = snakeCaseTableName.toLowerCase();
        return Identifier.toIdentifier(snakeCaseTableName);
    }

}