package cn.warpin.core.base.dao;

import cn.warpin.core.base.condition.BaseCondition;
import cn.warpin.core.base.condition.QueryCondition;
import cn.warpin.core.base.tableConf.bean.TableConf;
import cn.warpin.core.constant.Prop;
import cn.warpin.core.constant.StandardName;
import cn.warpin.core.database.redis.RedisOperate;
import cn.warpin.core.result.Result;
import cn.warpin.core.util.ArrayUtil;
import cn.warpin.core.util.StrUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public class CommonRepository {


    @PersistenceContext()
    private EntityManager entityManager;


    // 这里要通过redis查询出来对应的表
    public List<TableConf> queryTableConf(String pkg) {
//        // 通过包名获取到实体类名称
//        StringBuffer hql = new StringBuffer("FROM TableConf WHERE 1=1 AND javaPkg = '" + pkg + "'");
//        Query query = entityManager.createQuery(hql.toString());
//        // 获取结果集
//        List<TableConf> confs = query.getResultList();
//        return confs;

        Map<String, String> map = RedisOperate.getMapValue("table_conf");
        String json = map.get(pkg);

        return new Gson().fromJson(json, new TypeToken<List<TableConf>>() {
        }.getType());
    }

    public Result query(QueryCondition queryCondition, String pkg) {
        BaseCondition baseCondition = queryCondition.getBaseCondition();
        List<TableConf> confs = queryTableConf(pkg);
        if (ArrayUtil.isEmpty(confs)) {
            return Result.success();
        }
        TableConf conf = confs.get(0);
        String entityName = conf.getEntityName();
        StringBuilder hql = new StringBuilder("FROM " + entityName + " WHERE 1=1 ");
        Map<String, Object> params = new HashMap<>();
        String exConditionHQL = DaoUtil.setExternalCondition(queryCondition, confs, params);
        hql.append(exConditionHQL);

        // 排序
        if (baseCondition != null && (StrUtil.isNotEmpty(baseCondition.getOderByFieldName()) && StrUtil.isNotEmpty(baseCondition.getOderByOption()))) {
            hql.append(" order by ").append(baseCondition.getOderByFieldName()).append(" ").append(baseCondition.getOderByOption()); // 按指定参数排序
            hql.append(",id ").append(baseCondition.getOderByOption()); // 如果第一个排序条件出现重复时，需要第二个唯一条件再进行降序排序
        } else {
            hql.append(" order by createdAt DESC"); // 默认创建时间倒序
        }

        Integer totalCount = null;
        int totalPage = 1;
        Query query = entityManager.createQuery(hql.toString());

        // 在这里赋值参数,绑定数据
        setParameters(query, confs, params);

        if (baseCondition != null && (baseCondition.getPage() != null && baseCondition.getLimit() != null)) {
            int beginIndex = (baseCondition.getPage() - 1) * baseCondition.getLimit();
            query.setFirstResult(beginIndex);
            query.setMaxResults(baseCondition.getLimit());
        }

        // 获取结果集
        List queryList = query.getResultList();
        // 计算总数和总页数
        if (baseCondition != null && (baseCondition.getPage() != null && baseCondition.getLimit() != null)) {
            totalCount = this.count(queryCondition, confs, entityName, exConditionHQL, params);
            totalPage = (totalCount + baseCondition.getLimit() - 1) / baseCondition.getLimit();
        } else {
            totalCount = queryList.size();
        }

        return Result.querySuccess(queryList, totalCount, totalPage);
    }

    /**
     * 查询数量
     *
     * @param queryCondition
     * @param tableName
     * @return
     */
    public int count(QueryCondition queryCondition, List<TableConf> confs, String tableName, String exConditionHQL, Map<String, Object> params) {
        StringBuilder hql = new StringBuilder("SELECT count(id) FROM " + tableName + " WHERE 1=1 ");
        if (StrUtil.isEmpty(exConditionHQL) && !confs.isEmpty()) {
            params = new HashMap<>();
            exConditionHQL = DaoUtil.setExternalCondition(queryCondition, confs, params);
        }
        hql.append(exConditionHQL);
        Query query = entityManager.createQuery(hql.toString());
        // 在这里赋值参数,绑定数据
        setParameters(query, confs, params);
        List<Long> list = query.getResultList();
        return list.get(0).intValue();
    }


    private void setParameters(Query query, List<TableConf> tableConfs, Map<String, Object> params) {
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getValue() != null) {
                String key = entry.getKey();
                if (StandardName.ID.equalsIgnoreCase(key)) {
                    query.setParameter(entry.getKey(), entry.getValue());
                    continue;
                }
                // 判断这个值是否是like操作，如果是的话要单独设置
                TableConf tc = tableConfs.stream().filter(o -> o.getColumnOrmName().equals(key)).toList().get(0);
                if (tc.getSqlSpellMode().equalsIgnoreCase(Prop.SqlMode.LIKE)) {
                    query.setParameter(entry.getKey(), "%" + entry.getValue().toString() + "%");
                } else {
                    query.setParameter(entry.getKey(), entry.getValue());
                }

            }
        }
    }


}
