package cn.warpin.core.base.dao;

import cn.warpin.core.util.ArrayUtil;
import cn.warpin.core.util.StrUtil;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import org.springframework.stereotype.Repository;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.*;
import java.util.Map.Entry;

/**
 * 基础数据访问对象类，提供常用的数据库操作方法。
 */
@Repository
public class BaseDao {

   @PersistenceContext()
    private EntityManager entityManager;

    /**
     * 局部更新
     *
     * @param EntityName    表名
     * @param object        实体类对象
     * @param conditionName 主键字段名
     */
    public void update(String EntityName, Object object, String conditionName) {
        boolean firstTime = true;
        StringBuffer sql = new StringBuffer("update " + EntityName + " set ");
        String name = "";
        String upperName = "";
        String conditionValue = "";

        try {
            List<Field> fieldList = new ArrayList<>();
            Class tempClass = object.getClass();
            while (tempClass != null) {//当父类为null的时候说明到达了最上层的父类(Object类).
                fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
                tempClass = tempClass.getSuperclass(); //得到父类,然后赋给自己
            }
            Field[] fields = fieldList.toArray(new Field[fieldList.size()]);
            Map<String, Object> params = new HashMap<>();
            for (Field item : fields) {
                name = item.getName(); // 获取属性的名字
                upperName = name.substring(0, 1).toUpperCase() + name.substring(1); // 将属性的首字符大写，方便构造get方法
                Method getMethod = object.getClass().getMethod("get" + upperName);// 获取原生类的get方法
                Object value = getMethod.invoke(object);
                params.put(name, value);
                if (name.equals(conditionName)) {
                    continue;
                }
                if (null != value && !"".equals(value)) {
                    sql.append(firstTime ? " " : ", ");
                    firstTime = false;
                    sql.append(name).append(" = ").append(":").append(name);
                }
            }
            sql.append(" where ").append(conditionName).append("=").append(":").append(conditionName);
            Query query = entityManager.createQuery(sql.toString());
            // 绑定数据
            for (Entry<String, Object> entry : params.entrySet()) {
                if (entry.getValue() != null && !"".equals(entry.getValue())) {
                    query.setParameter(entry.getKey(), entry.getValue());
                }
            }

            query.executeUpdate();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }


    /**
     * 根据多条件更新
     */
    public void updateByMultiCondition(String EntityName, Map<String, Object> param, Map<String, Object> condition) {
        StringBuffer sql = new StringBuffer("update " + EntityName + " set ");
        int index = 0;
        for (Entry<String, Object> entry : param.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            String val = StrUtil.specialCharHandleForDB(value.toString());
            sql.append(index == 0 ? key + "='" + value + "'" : ", " + key + "='" + val + "'");
            index++;
        }
        sql.append(" where ");
        index = 0;
        for (Entry<String, Object> entry : condition.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            String val = StrUtil.specialCharHandleForDB(value.toString());
            sql.append(index == 0 ? key + "='" + value + "'" : " and " + key + "='" + val + "'");
            index++;
        }

        Query query = entityManager.createNativeQuery(sql.toString());
        query.executeUpdate();
    }


    /**
     * sql更新count语句
     */
    public void updateCount(String EntityName, Object object, String conditionName) throws Exception {
        boolean firstTime = true;
        StringBuffer sql = new StringBuffer("update " + EntityName + " set ");
        String name = "";
        String upperName = "";
        String conditionValue = "";
        List<Field> fieldList = new ArrayList<>();
        Class tempClass = object.getClass();
        while (tempClass != null) {//当父类为null的时候说明到达了最上层的父类(Object类).
            fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
            tempClass = tempClass.getSuperclass(); //得到父类,然后赋给自己
        }
        Field[] field = fieldList.toArray(new Field[fieldList.size()]);
        for (int i = 0; i < field.length; i++) {
            name = field[i].getName(); // 获取属性的名字
            upperName = name.substring(0, 1).toUpperCase() + name.substring(1); // 将属性的首字符大写，方便构造get方法
            Method getMethod = object.getClass().getMethod("get" + upperName);// 获取原生类的get方法
            Object value = getMethod.invoke(object);
            if (name.equals(conditionName)) {
                conditionValue = value.toString();
            } else if (null != value) {
                sql.append(firstTime ? " " : ",");
                firstTime = false;
                sql.append(name + "=" + name + "+" + value);
            }
        }
        sql.append(" where " + conditionName + "='" + conditionValue + "'");
        Query query = entityManager.createNativeQuery(sql.toString());
        query.executeUpdate();
    }

    /**
     * 批量更新表中数据
     *
     * @param EntityName
     * @param object
     * @param conditionName
     * @param idList
     * @param isString
     * @throws Exception
     */
    public void updateIN(String EntityName, Object object, String conditionName, List idList, boolean isString) throws Exception {
        String conditionValue = StrUtil.idList2Str(idList, isString);
        if (StrUtil.isEmpty(conditionValue)) {
            return;
        }
        boolean firstTime = true;
        StringBuffer sql = new StringBuffer("update " + EntityName + " set ");
        String name = "";
        String upperName = "";
        Field[] field = object.getClass().getDeclaredFields();
        for (int i = 0; i < field.length; i++) {
            name = field[i].getName(); // 获取属性的名字
            upperName = name.substring(0, 1).toUpperCase() + name.substring(1); // 将属性的首字符大写，方便构造get方法
            Method getMethod = object.getClass().getMethod("get" + upperName);// 获取原生类的get方法
            Object value = getMethod.invoke(object);
            if (null != value && !"".equals(value)) {
                sql.append(firstTime ? " " : ",");
                firstTime = false;
                sql.append(name + "='" + value.toString() + "'");
            }
        }
        sql.append(" where " + conditionName + " in (" + conditionValue + ")");
        Query query = entityManager.createNativeQuery(sql.toString());
        query.executeUpdate();
    }

    /**
     * 批量删除
     *
     * @param
     * @param EntityName
     * @param conditionName
     */
    public void batchDelete(String[] idArray, String EntityName, String conditionName) {
        StringBuffer sql = new StringBuffer("delete from " + EntityName);
        if (null != idArray && idArray.length > 0) {
            sql.append(" where ");
            for (int i = 0; i < idArray.length; i++) {
                sql.append(i == 0 ? conditionName + " = '" + idArray[i] + "'" : " or " + conditionName + " = '" + idArray[i] + "'");
            }
        }
        Query query = entityManager.createNativeQuery(sql.toString());
        query.executeUpdate();
    }

    /**
     * 多条件删除
     *
     * @param EntityName
     * @param param
     */
    public void batchDeleteByMultiCondition(String EntityName, Map<String, Object> param) {
        StringBuffer sql = new StringBuffer("delete from " + EntityName + " where ");
        int index = 0;
        for (Entry<String, Object> entry : param.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            sql.append(index == 0 ? key + " = '" + value + "'" : " and " + key + " = '" + value + "'");
            index++;
        }
        Query query = entityManager.createNativeQuery(sql.toString());
        query.executeUpdate();
    }

    /**
     * 单条件统计数量
     *
     * @param EntityName
     * @param object
     * @param countName
     * @param conditionName
     * @return
     * @throws Exception
     */
    public Integer count(String EntityName, Object object, String countName, String conditionName) throws Exception {
        Integer countNum = 0;
        StringBuffer sql = new StringBuffer("select COUNT(" + countName + ") from " + EntityName);
        if (StrUtil.isNotEmpty(conditionName)) {
            String name = "";
            String upperName = "";
            String conditionValue = "";
            List<Field> fieldList = new ArrayList<>();
            Class tempClass = object.getClass();
            while (tempClass != null) {//当父类为null的时候说明到达了最上层的父类(Object类).
                fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
                tempClass = tempClass.getSuperclass(); //得到父类,然后赋给自己
            }
            Field[] field = fieldList.toArray(new Field[fieldList.size()]);
            for (int i = 0; i < field.length; i++) {
                name = field[i].getName(); // 获取属性的名字
                upperName = name.substring(0, 1).toUpperCase() + name.substring(1); // 将属性的首字符大写，方便构造get方法
                Method getMethod = object.getClass().getMethod("get" + upperName);// 获取原生类的get方法
                Object value = getMethod.invoke(object);
                if (name.equals(conditionName)) {
                    conditionValue = value.toString();
                    break;
                }
            }
            sql.append(" where " + conditionName + "='" + conditionValue + "'");
        }
        Query query = entityManager.createNativeQuery(sql.toString());
        List countList = query.getResultList();
        if (ArrayUtil.isNotEmpty(countList)) {
            countNum = Integer.valueOf(countList.get(0).toString());
        }
        return countNum;
    }


    /**
     * 多条件统计数量
     *
     * @param EntityName
     * @param countName
     * @param conditionParam
     * @return
     */
    public Integer count(String EntityName, String countName, Map<String, Object> conditionParam) {
        Integer countNum = 0;
        StringBuffer sql = new StringBuffer("select COUNT(" + countName + ") from " + EntityName + " where ");
        int index = 0;
        for (Entry<String, Object> entry : conditionParam.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            sql.append(index == 0 ? key + " = '" + value + "'" : " and " + key + " = '" + value + "'");
            index++;
        }
        Query query = entityManager.createNativeQuery(sql.toString());
        List countList = query.getResultList();
        if (ArrayUtil.isNotEmpty(countList)) {
            countNum = Integer.valueOf(countList.get(0).toString());
        }
        return countNum;
    }


    /**
     * 单条件 数量 求和
     *
     * @param EntityName
     * @param countName
     * @param conditionParam
     * @return
     */
    public BigDecimal sum(String EntityName, String countName, Map<String, Object> conditionParam) {
        BigDecimal sumNum = new BigDecimal("0.00");
        StringBuffer sql = new StringBuffer("select SUM(" + countName + ") from " + EntityName + " where ");
        int index = 0;
        for (Entry<String, Object> entry : conditionParam.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            sql.append(index == 0 ? key + " like '" + value + "'" : " and " + key + " like '" + value + "'");
            index++;
        }
        Query query = entityManager.createNativeQuery(sql.toString());
        List countList = query.getResultList();
        if (ArrayUtil.isNotEmpty(countList)) {
            sumNum = BigDecimal.valueOf(Double.valueOf(countList.get(0) == null ? "0.00" : countList.get(0).toString()));
        }
        return sumNum;
    }


}
