package cn.warpin.core.base.condition;

import cn.warpin.core.util.ObjectUtil;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 查询条件类，用于描述查询操作的条件。
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class QueryCondition {

    /**
     * 序列化版本号
     */
    private static final long serialVersionUID = -1L;

    /**
     * 基础查询条件
     */
    private BaseCondition baseCondition;

    /**
     * 实体类条件
     */
    private Object entity;

    /**
     * 创建人姓名
     */
    private String createdBy;

    /**
     * 修改人姓名
     */
    private String updatedBy;

    /**
     * 使用基础查询条件构造查询条件对象。
     *
     * @param baseCondition 基础查询条件
     */
    public QueryCondition(BaseCondition baseCondition) {
        this.baseCondition = baseCondition;
    }

    /**
     * 使用基础查询条件和实体对象构造查询条件对象。
     *
     * @param baseCondition 基础查询条件
     * @param entity        实体对象
     */
    public QueryCondition(BaseCondition baseCondition, Object entity) {
        this.baseCondition = baseCondition;

        // 将对象转换成 Map，以便使用
        this.entity = ObjectUtil.transBean2Map(entity);
    }
}
