package cn.warpin.core.base.condition;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 基础查询条件类，用于构建数据库查询条件。
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class BaseCondition {

    /**
     * 查询起始位置
     */
    private Integer start;

    /**
     * 当前页数
     */
    private Integer page;

    /**
     * 每页显示数量
     */
    private Integer limit;

    /**
     * 总页数
     */
    private Integer totalPage;

    /**
     * 总记录数
     */
    private Long totalCount;

    /**
     * 排序字段名称
     */
    private String oderByFieldName;

    /**
     * 排序选项
     */
    private String oderByOption;

    /**
     * 主键 ID
     */
    private String id;


    /**
     * 主表外键名称
     */
    private String foreignKeyName;

    /**
     * 主表外键的值
     */
    private String foreignKeyValue;

    /**
     * 构造函数，初始化主键 ID。
     *
     * @param id 主键 ID
     */
    public BaseCondition(String id) {
        this.id = id;
    }

}
