package cn.warpin.core.base.baseEntity;

import cn.warpin.core.base.jpa.jpaComment.annotation.ColumnComment;
import com.fasterxml.jackson.annotation.JsonFormat;
import jakarta.persistence.*;
import lombok.Data;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;
import org.springframework.format.annotation.DateTimeFormat;

import java.sql.Timestamp;

@Data
@MappedSuperclass
public class BaseEntity {

    /**
     * 主键ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(nullable = false)
    @ColumnComment("主键ID")
    private Integer id;

    /**
     * 创建时间
     */
    @ColumnComment("创建时间")
    @Column(name = "created_at", nullable = false, updatable = false)
    @CreationTimestamp
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Timestamp createdAt;

    /**
     * 更新时间
     */
    @ColumnComment("更新时间")
    @Column(name = "updated_at", insertable = false)
    @UpdateTimestamp
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Timestamp updatedAt;

    /**
     * 创建人账号
     */
    @ColumnComment("创建人账号")
    @Column(name = "created_by", length = 20)
    private String createdBy;

    /**
     * 修改人账号
     */
    @ColumnComment("修改人账号")
    @Column(name = "updated_by", length = 20)
    private String updatedBy;

    /**
     * 软删除时间
     */
    @ColumnComment("软删除时间")
    @Column(name = "deleted_at", insertable = false)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Timestamp deletedAt;

    /**
     * 每个类对应的唯一标识UUID，可以为空
     */
    @ColumnComment("唯一标识UUID")
    @Column(name = "unique_tag", unique = true, length = 255)
    private String uniqueTag;

}

