/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.util;

import cn.warpin.core.exception.ResultException;
import cn.warpin.core.result.ResCode;
import cn.warpin.core.result.Result;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlUtil {
    public static Result parseCasResponse(String xmlResponse) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(new ByteArrayInputStream(xmlResponse.getBytes(StandardCharsets.UTF_8)));
            doc.getDocumentElement().normalize();
            NodeList successList = doc.getElementsByTagName("cas:authenticationSuccess");
            if (successList.getLength() > 0) {
                return Result.success();
            }
            NodeList failureList = doc.getElementsByTagName("cas:authenticationFailure");
            if (failureList.getLength() > 0) {
                Element failureElement = (Element)failureList.item(0);
                return Result.fail(ResCode.INVALID_TICKET, failureElement.getAttribute("code"));
            }
        }
        catch (Exception e) {
            throw new ResultException("\u89e3\u6790CAS\u8ba4\u8bc1\u7ed3\u679c\u5931\u8d25");
        }
        return Result.success();
    }

    public static void main(String[] args) {
        String successXml = "<cas:serviceResponse xmlns:cas='http://www.yale.edu/tp/cas'>\n    <cas:authenticationSuccess>\n        <cas:user>1</cas:user>\n\n        <cas:attributes>\n            <cas:credentialType>UsernamePasswordCredential</cas:credentialType>\n            <cas:clientIpAddress>192.168.0.101</cas:clientIpAddress>\n            <cas:isFromNewLogin>false</cas:isFromNewLogin>\n            <cas:authenticationDate>2024-05-10T03:16:22.628376800Z</cas:authenticationDate>\n            <cas:authenticationMethod>org.apereo.cas.customize.UsernamePasswordAuthentication</cas:authenticationMethod>\n            <cas:geoLocation>unknown</cas:geoLocation>\n            <cas:successfulAuthenticationHandlers>org.apereo.cas.customize.UsernamePasswordAuthentication\n            </cas:successfulAuthenticationHandlers>\n            <cas:serverIpAddress>192.168.0.101</cas:serverIpAddress>\n            <cas:userAgent>Apifox/1.0.0 (https://apifox.com)</cas:userAgent>\n            <cas:longTermAuthenticationRequestTokenUsed>false</cas:longTermAuthenticationRequestTokenUsed>\n        </cas:attributes>\n    </cas:authenticationSuccess>\n</cas:serviceResponse>";
        String failureXml = "<cas:serviceResponse xmlns:cas='http://www.yale.edu/tp/cas'>\n    <cas:authenticationFailure code=\"INVALID_TICKET\">\u672a\u80fd\u591f\u8bc6\u522b\u51fa\u76ee\u6807 &#39;ST-1-Mc6-0KTUi-uPjeJGTup3ZAR28xM1-Answer&#39;\u7968\u6839\n    </cas:authenticationFailure>\n</cas:serviceResponse>";
        System.out.println(XmlUtil.parseCasResponse(successXml));
        System.out.println(XmlUtil.parseCasResponse(failureXml));
    }
}

