/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.util;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang3.RandomStringUtils;

public class StrUtil {
    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StrUtil.isEmpty(str);
    }

    public static String uuid32() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String uuid36() {
        return UUID.randomUUID().toString();
    }

    public static String randomKey(int digitCapacity) {
        if (digitCapacity == 0) {
            digitCapacity = 12;
        }
        return RandomStringUtils.randomAlphanumeric((int)digitCapacity).toUpperCase();
    }

    public static String join(String[] strArr, String split) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strArr.length; ++i) {
            if (i > 0) {
                sb.append(split);
            }
            sb.append(strArr[i]);
        }
        return sb.toString();
    }

    public static String genOrderNum() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
        String formattedDateTime = now.format(formatter);
        return formattedDateTime + StrUtil.randomKey(8);
    }

    public static String getNowStr() {
        Calendar now = Calendar.getInstance();
        return String.valueOf(now.get(1)) + (now.get(2) + 1) + now.get(5) + now.get(11) + now.get(12) + now.get(13) + now.get(14);
    }

    public static List<Integer> ids2IntList(String ids) {
        String[] arr;
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String s : arr = ids.split(",")) {
            list.add(Integer.parseInt(s));
        }
        return list;
    }

    public static String formatStringIDS(String ids) {
        List<String> idStringList = StrUtil.ids2StringList(ids);
        ids = StrUtil.idList2Str(idStringList, true);
        return ids;
    }

    public static List<String> ids2StringList(String ids) {
        String[] arr;
        ArrayList<String> list = new ArrayList<String>();
        for (String s : arr = ids.split(",")) {
            list.add(s);
        }
        return list;
    }

    public static String idList2Str(List idList, boolean isVarchar) {
        Object result = "";
        if (null == idList || idList.size() == 0) {
            return result;
        }
        for (int i = 0; i < idList.size(); ++i) {
            result = isVarchar ? (String)result + (i == 0 ? "'" + String.valueOf(idList.get(i)) + "'" : ",'" + String.valueOf(idList.get(i)) + "'") : (String)result + String.valueOf(i == 0 ? idList.get(i) : "," + String.valueOf(idList.get(i)));
        }
        return result;
    }

    public static String specialCharHandleForDB(String text) {
        if (StrUtil.isEmpty(text)) {
            return "";
        }
        text = text.replace("'", "\\'");
        text = text.replace("\"", "\\\"");
        return text;
    }

    public static String fmtKey(String key, String prefix) {
        if (StrUtil.isNotEmpty(key)) {
            String newKey = key.toUpperCase();
            if (StrUtil.isNotEmpty(prefix) && !newKey.startsWith(prefix)) {
                return prefix + "_" + newKey;
            }
            return newKey;
        }
        return null;
    }

    public static String replace(String oldStr, String[] replaceStrArr, String tag) {
        int start;
        String resStr = oldStr;
        for (int i = 0; i < replaceStrArr.length && (start = resStr.indexOf(tag)) != -1; ++i) {
            int end = start + tag.length();
            StringBuilder sb = new StringBuilder(resStr);
            sb.replace(start, end, replaceStrArr[i]);
            resStr = sb.toString();
        }
        return resStr;
    }

    public static int getStrExistCount(String str, String inStr) {
        int count = (str.length() - str.replace(inStr, "").length()) / inStr.length();
        return count;
    }

    public static String getRandomString(int length) {
        String str = "zxcvbnmlkjhgfdsaqwertyuiopQWERTYUIOPASDFGHJKLZXCVBNM1234567890";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(62);
            sb.append(str.charAt(number));
        }
        return sb.toString();
    }

    public static Boolean checkUrlWithHttp(String url) {
        if ((url = url.toLowerCase()).startsWith("http") || url.startsWith("https")) {
            return true;
        }
        return false;
    }

    public static String upperCaseFirstName(String str) {
        char[] cs = str.toCharArray();
        if (Character.isUpperCase(cs[0])) {
            return str;
        }
        cs[0] = (char)(cs[0] - 32);
        return String.valueOf(cs);
    }

    public static String lowerCaseFirstName(String str) {
        char[] cs = str.toCharArray();
        if (Character.isLowerCase(cs[0])) {
            return str;
        }
        cs[0] = (char)(cs[0] + 32);
        return String.valueOf(cs);
    }

    public static String transformName(String name, boolean upCaseFirst) {
        StringBuilder sb = new StringBuilder();
        String[] words = name.split("_");
        if (words.length > 0) {
            for (String word : words) {
                String captureName;
                if (!upCaseFirst) {
                    captureName = word;
                    upCaseFirst = true;
                } else {
                    captureName = StrUtil.upperCaseFirstName(word);
                }
                sb.append(captureName);
            }
            return sb.toString();
        }
        return words[0];
    }

    public static String getEntityNameFromPkg(String pkg, Boolean lowerCase) {
        String[] arr = pkg.split("\\.");
        String eName = arr[arr.length - 1];
        if (lowerCase.booleanValue()) {
            eName = StrUtil.lowerCaseFirstName(eName);
        }
        return eName;
    }

    public static String amountToCH(String amount) {
        if (((String)amount).contains(".")) {
            Double d = Double.parseDouble((String)amount);
            amount = "" + d.intValue();
        }
        char[] arr1 = new char[]{'\u96f6', '\u58f9', '\u8d30', '\u53c1', '\u8086', '\u4f0d', '\u9646', '\u67d2', '\u634c', '\u7396'};
        char[] arr2 = new char[]{'\u96f6', '\u96f6', '\u96f6', '\u96f6', '\u96f6', '\u96f6', '\u96f6', '\u96f6'};
        for (int k = 0; k < ((String)amount).length(); ++k) {
            arr2[8 - ((String)amount).length() + k] = arr1[((String)amount).charAt(k) - 48];
        }
        Object result = "";
        block11: for (int i = 0; i < arr2.length; ++i) {
            if (arr2[i] == '\u96f6' && i < arr2.length - 1) continue;
            switch (i) {
                case 0: {
                    result = (String)result + arr2[i] + "\u4edf";
                    continue block11;
                }
                case 1: {
                    result = (String)result + arr2[i] + "\u4f70";
                    continue block11;
                }
                case 2: {
                    result = (String)result + arr2[i] + "\u62fe";
                    continue block11;
                }
                case 3: {
                    result = (String)result + arr2[i] + "\u4e07";
                    continue block11;
                }
                case 4: {
                    result = (String)result + arr2[i] + "\u4edf";
                    continue block11;
                }
                case 5: {
                    result = (String)result + arr2[i] + "\u4f70";
                    continue block11;
                }
                case 6: {
                    result = (String)result + arr2[i] + "\u62fe";
                    continue block11;
                }
                case 7: {
                    char last = arr2[i];
                    result = last == '\u96f6' ? (String)result + "\u5706" : (String)result + arr2[i] + "\u5706";
                }
            }
        }
        return result;
    }

    public static String intToRoman(int num) {
        HashMap<Integer, String> maps = new HashMap<Integer, String>();
        maps.put(1, "I");
        maps.put(5, "V");
        maps.put(10, "X");
        maps.put(50, "L");
        maps.put(100, "C");
        maps.put(500, "D");
        maps.put(1000, "M");
        maps.put(4, "IV");
        maps.put(9, "IX");
        maps.put(40, "XL");
        maps.put(90, "XC");
        maps.put(400, "CD");
        maps.put(900, "CM");
        Object res = "";
        int[] digits = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        block0: while (num > 0) {
            for (int i = 0; i < digits.length; ++i) {
                if (num < digits[i]) continue;
                res = (String)res + (String)maps.get(digits[i]);
                num -= digits[i];
                continue block0;
            }
        }
        return res;
    }

    public static String getSurplusString(String source, String rex, String replace) {
        Object res = "";
        int startIndex = source.indexOf(rex);
        if (startIndex != -1) {
            int endIndex = source.indexOf(rex, startIndex + 1);
            if (endIndex != -1) {
                String beforeStart = source.substring(0, startIndex + rex.length());
                String afterEnd = source.substring(endIndex);
                res = beforeStart + replace + afterEnd;
            } else {
                res = source;
            }
        } else {
            res = source;
        }
        String result = ((String)res).replace(rex, "");
        return result;
    }

    public static String extractKeyFromErrorMessage(String message) {
        String key = null;
        if (message != null && message.contains("Duplicate entry")) {
            int startIndex = message.indexOf("key '") + 5;
            int endIndex = message.indexOf("'", startIndex);
            if (startIndex > 0 && endIndex > startIndex) {
                key = message.substring(startIndex, endIndex);
            }
        }
        return key;
    }

    public static void main(String[] args) {
        HashMap<String, String> categoryTypeVO = new HashMap<String, String>();
        categoryTypeVO.put("a", "1");
        categoryTypeVO.put("uniqueTag", "1");
        boolean b = StrUtil.isEmpty((String)categoryTypeVO.get("uniqueTag"));
        System.out.println(b);
    }
}

